/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISETBST_H
#define _ISETBST_H

#include <iaset.h>
#include <iicset.h>
#include <iivset.h>
#include <iisetbst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSetAsBstTree;

template <class Element, class ElementOps>
class IGSetAsBstTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGSetAsBstTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetAsBstTreeCursor
                            (IGSetAsBstTree
                              <
                               Element, ElementOps> const&);

  IGSetAsBstTreeCursor <Element, ElementOps>&
           operator=        (IGSetAsBstTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetAsBstTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSetAsBstTree :
  public IASet <Element> {
protected:

  typedef  IGSetAsBstTree <Element, ElementOps> Self;

  typedef  ISetAsBstTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetAsBstTreeTypedef(Element, ElementOps)\
  typedef  ISetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetAsBstTreeTypedef (Element, ElementOps);

public:

  typedef  IGSetAsBstTreeCursor
            <Element, ElementOps> Cursor;


           IGSetAsBstTree
                            (INumber = 100);

           IGSetAsBstTree
                            (IGSetAsBstTree
                              <
                               Element, ElementOps> const&);

  IGSetAsBstTree <Element, ElementOps>&
           operator=        (IGSetAsBstTree
                              <
                               Element, ElementOps> const&);


protected:

           IGSetAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSetAsBstTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetAsBstTreeCursor
            <Element, ElementOps>;



};

template <class Element>
class ISetAsBstTree :
  public IGSetAsBstTree
          <Element, ICOps <Element> > {

  typedef  IGSetAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISetAsBstTree <Element> Self;

#define ISetAsBstTreeTypedef(Element)\
  typedef  ISetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISetAsBstTree
                            (INumber = 100);


protected:

           ISetAsBstTree
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSetAsBstTree :
  public IGSetAsBstTree
          <Element, ElementOps > {

  typedef  IVGSetAsBstTree
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetAsBstTreeTypedef(Element, ElementOps)\
  typedef  ISetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetAsBstTreeTypedef (Element, ElementOps);

public:

           IVGSetAsBstTree
                            (INumber = 100);


protected:

           IVGSetAsBstTree
                              (PureImplementation&);

private:


};

template <class Element>
class IVSetAsBstTree :
  public IVGSetAsBstTree
          <Element, ICOps <Element> > {

  typedef  IVGSetAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSetAsBstTree <Element> Self;

#define IVSetAsBstTreeTypedef(Element)\
  typedef  IVSetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSetAsBstTree
                            (INumber = 100);


protected:

           IVSetAsBstTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isetbst.inl>

#pragma info (restore)
#pragma pack ()

#endif
