/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSetAsBstTreeCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetAsBstTreeCursor <Element, ElementOps>::
IGSetAsBstTreeCursor
  (IGSetAsBstTree
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSetAsBstTreeCursor <Element, ElementOps>&
IGSetAsBstTreeCursor <Element, ElementOps>::
operator=
  (IGSetAsBstTreeCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetAsBstTreeCursor <Element, ElementOps>::
IGSetAsBstTreeCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGSetAsBstTree
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetAsBstTree <Element, ElementOps>::
IGSetAsBstTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSetAsBstTree <Element, ElementOps>::
IGSetAsBstTree
  (IGSetAsBstTree
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSetAsBstTree <Element, ElementOps>&
IGSetAsBstTree <Element, ElementOps>::
operator= (IGSetAsBstTree
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetAsBstTree <Element, ElementOps>::
IGSetAsBstTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSetAsBstTree
 <Element, ElementOps>::Implementation&
IGSetAsBstTree <Element, ElementOps>::
ImplOf (IGSetAsBstTree
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISetAsBstTree
// ---

// public members

template <class Element>
inline
ISetAsBstTree <Element>::
ISetAsBstTree (INumber numberOfElements)
: IGSetAsBstTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISetAsBstTree <Element>::
ISetAsBstTree (PureImplementation& impl)
: IGSetAsBstTree
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSetAsBstTree
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSetAsBstTree <Element, ElementOps>::
IVGSetAsBstTree (INumber numberOfElements)
: IGSetAsBstTree
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSetAsBstTree <Element, ElementOps>::
IVGSetAsBstTree (PureImplementation& impl)
: IGSetAsBstTree
    <Element, ElementOps> (impl)
{
}

// ---
// IVSetAsBstTree
// ---

// public members

template <class Element>
inline
IVSetAsBstTree <Element>::
IVSetAsBstTree (INumber numberOfElements)
: IVGSetAsBstTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSetAsBstTree <Element>::
IVSetAsBstTree (PureImplementation& impl)
: IVGSetAsBstTree
   <Element, ICOps <Element> > (impl)
{
}
