#ifndef _ISETCV_
  #define _ISETCV_
/*******************************************************************************
* FILE NAME: isetcv.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISetCanvas                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icanvas.hpp>
#include <ipoint.hpp>
#include <irect.hpp>

class IColor;
class IResourceId;
class IString;
class ISetCanvasObject;
class ISetCanvasData;
class ISetCanvasResizeHandler;

#pragma pack(4)

class ISetCanvas : public ICanvas {
typedef ICanvas
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  ISetCanvas  ( unsigned long     windowIdentifier,
                IWindow*          parent,
                IWindow*          owner,
                const IRectangle& initial = IRectangle(),
                const Style&      style = defaultStyle() );
virtual
 ~ISetCanvas  ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, ISetCanvas, ICanvas, IWindow);
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU horizontalDecks,
  IC_IMPORTU verticalDecks,
  IC_IMPORTU packTight,
  IC_IMPORTU packEven,
  IC_IMPORTU packExpanded,
  IC_IMPORTU leftAlign,
  IC_IMPORTU rightAlign,
  IC_IMPORTU centerAlign,
  IC_IMPORTU topAlign,
  IC_IMPORTU bottomAlign,
  IC_IMPORTU centerVerticalAlign,
  IC_IMPORTU decksByGroup;
static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------- Spacing of Child Windows -------------------------*/
enum Alignment {
  topLeft,
  topCenter,
  topRight,
  centerLeft,
  centerCenter,
  centerRight,
  bottomLeft,
  bottomCenter,
  bottomRight
  };
enum PackType {
  tight,
  even,
  expanded
  };

Alignment
  alignment    ( ) const;
virtual ISetCanvas
 &setAlignment ( Alignment     value );
PackType
  packType     ( ) const;
virtual ISetCanvas
 &setPackType  ( PackType      value );
ISize
  margin       ( ) const,
  pad          ( ) const;
unsigned long
  groupPad     ( ) const;
virtual ISetCanvas
 &setMargin    ( const ISize&  margin ),
 &setPad       ( const ISize&  pad ),
 &setGroupPad  ( unsigned long groupPad );

/*---------------------------------- Decks -----------------------------------*/
enum DeckOrientation {
  horizontal,
  vertical
  };
DeckOrientation
  deckOrientation    ( ) const;
unsigned long
  deckCount          ( ) const;
virtual ISetCanvas
 &setDeckOrientation ( DeckOrientation value ),
 &setDeckCount       ( unsigned long decks );

/*----------------------------------- Text -----------------------------------*/
virtual ISetCanvas
 &setText ( const char*        text ),
 &setText ( const IResourceId& text );
virtual IString
  text    ( ) const;

/*---------------------------------- Layout Members --------------------------*/
virtual ISetCanvas
 &setLayoutDistorted ( unsigned long layoutAttributesOn,
                       unsigned long layoutAttributesOff );

/*--------------------------- Notification Members ---------------------------*/
static INotificationId const
  IC_IMPORTU textId,
  IC_IMPORTU deckOrientationId;



protected:
/*---------------------------------- Layout ----------------------------------*/
virtual ISetCanvas
 &layout ( );

/*----------------------------------- Text -----------------------------------*/
virtual ISetCanvas
 &expandForText ( );

private:
/*----------------------------- Hidden Members -------------------------------*/
  ISetCanvas ( const ISetCanvas& canvas );
ISetCanvas
 &operator=  ( const ISetCanvas& canvas );

/*--------------------------------- Private ----------------------------------*/
friend ISetCanvasResizeHandler;

static Style
  currentDefaultStyle;

unsigned long
  ulClNumDecks,
  ulClGroupPad;
ISize
  sizClMargin,
  sizClPad;
ISetCanvasResizeHandler
 *sizeHandler;

ISetCanvasData
 *fSetCanvasData;

}; // ISetCanvas

INESTEDBITFLAGCLASSFUNCS(Style, ISetCanvas);

#pragma pack()

/*----------------------------- Inline Functions -----------------------------*/
  #include <isetcv.inl>

#endif /* _ISETCV_ */
