/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISETDIL_H
#define _ISETDIL_H

#include <iaset.h>
#include <iicset.h>
#include <iivset.h>
#include <iisetdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSetAsDilTable;

template <class Element, class ElementOps>
class IGSetAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGSetAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetAsDilTableCursor
                            (IGSetAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSetAsDilTableCursor <Element, ElementOps>&
           operator=        (IGSetAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSetAsDilTable :
  public IASet <Element> {
protected:

  typedef  IGSetAsDilTable <Element, ElementOps> Self;

  typedef  ISetAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetAsDilTableTypedef(Element, ElementOps)\
  typedef  ISetAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetAsDilTableTypedef (Element, ElementOps);

public:

  typedef  IGSetAsDilTableCursor
            <Element, ElementOps> Cursor;


           IGSetAsDilTable
                            (INumber = 100);

           IGSetAsDilTable
                            (IGSetAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSetAsDilTable <Element, ElementOps>&
           operator=        (IGSetAsDilTable
                              <
                               Element, ElementOps> const&);


protected:

           IGSetAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSetAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetAsDilTableCursor
            <Element, ElementOps>;



};

template <class Element>
class ISetAsDilTable :
  public IGSetAsDilTable
          <Element, ICOps <Element> > {

  typedef  IGSetAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISetAsDilTable <Element> Self;

#define ISetAsDilTableTypedef(Element)\
  typedef  ISetAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISetAsDilTable
                            (INumber = 100);


protected:

           ISetAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSetAsDilTable :
  public IGSetAsDilTable
          <Element, ElementOps > {

  typedef  IVGSetAsDilTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetAsDilTableTypedef(Element, ElementOps)\
  typedef  ISetAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetAsDilTableTypedef (Element, ElementOps);

public:

           IVGSetAsDilTable
                            (INumber = 100);


protected:

           IVGSetAsDilTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVSetAsDilTable :
  public IVGSetAsDilTable
          <Element, ICOps <Element> > {

  typedef  IVGSetAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSetAsDilTable <Element> Self;

#define IVSetAsDilTableTypedef(Element)\
  typedef  IVSetAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSetAsDilTable
                            (INumber = 100);


protected:

           IVSetAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isetdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
