/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISETHSH_H
#define _ISETHSH_H

#include <iaset.h>
#include <iicset.h>
#include <iivset.h>
#include <iisethsh.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSetAsHshTable;

template <class Element, class ElementOps>
class IGSetAsHshTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGSetAsHshTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetAsHshTableCursor
                            (IGSetAsHshTable
                              <
                               Element, ElementOps> const&);

  IGSetAsHshTableCursor <Element, ElementOps>&
           operator=        (IGSetAsHshTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetAsHshTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSetAsHshTable :
  public IASet <Element> {
protected:

  typedef  IGSetAsHshTable <Element, ElementOps> Self;

  typedef  ISetAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetAsHshTableTypedef(Element, ElementOps)\
  typedef  ISetAsHshTableOps\
            <Element,\
             IWEHOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetAsHshTableTypedef (Element, ElementOps);

public:

  typedef  IGSetAsHshTableCursor
            <Element, ElementOps> Cursor;


           IGSetAsHshTable
                            (INumber = 100);

           IGSetAsHshTable
                            (IGSetAsHshTable
                              <
                               Element, ElementOps> const&);

  IGSetAsHshTable <Element, ElementOps>&
           operator=        (IGSetAsHshTable
                              <
                               Element, ElementOps> const&);


protected:

           IGSetAsHshTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSetAsHshTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetAsHshTableCursor
            <Element, ElementOps>;



};

template <class Element>
class ISetAsHshTable :
  public IGSetAsHshTable
          <Element, IEHOps <Element> > {

  typedef  IGSetAsHshTable
            <Element,
             IEHOps <Element> > Inherited;

protected:

  typedef  ISetAsHshTable <Element> Self;

#define ISetAsHshTableTypedef(Element)\
  typedef  ISetAsHshTableOps\
            <Element,\
             IWEHOps <Element, IEHOps <Element> >,\
             Implementation> Instantiation

public:

           ISetAsHshTable
                            (INumber = 100);


protected:

           ISetAsHshTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSetAsHshTable :
  public IGSetAsHshTable
          <Element, ElementOps > {

  typedef  IVGSetAsHshTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetAsHshTableTypedef(Element, ElementOps)\
  typedef  ISetAsHshTableOps\
            <Element,\
             IWEHOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetAsHshTableTypedef (Element, ElementOps);

public:

           IVGSetAsHshTable
                            (INumber = 100);


protected:

           IVGSetAsHshTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVSetAsHshTable :
  public IVGSetAsHshTable
          <Element, IEHOps <Element> > {

  typedef  IVGSetAsHshTable
            <Element,
             IEHOps <Element> > Inherited;

protected:

  typedef  IVSetAsHshTable <Element> Self;

#define IVSetAsHshTableTypedef(Element)\
  typedef  IVSetAsHshTableOps\
            <Element,\
             IWEHOps <Element, IEHOps <Element> >,\
             Implementation> Instantiation

public:

           IVSetAsHshTable
                            (INumber = 100);


protected:

           IVSetAsHshTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isethsh.inl>

#pragma info (restore)
#pragma pack ()

#endif
