/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISETLST_H
#define _ISETLST_H

#include <iaset.h>
#include <iicset.h>
#include <iivset.h>
#include <iisetlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSetAsList;

template <class Element, class ElementOps>
class IGSetAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGSetAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetAsListCursor
                            (IGSetAsList
                              <
                               Element, ElementOps> const&);

  IGSetAsListCursor <Element, ElementOps>&
           operator=        (IGSetAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSetAsList :
  public IASet <Element> {
protected:

  typedef  IGSetAsList <Element, ElementOps> Self;

  typedef  ISetAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetAsListTypedef(Element, ElementOps)\
  typedef  ISetAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetAsListTypedef (Element, ElementOps);

public:

  typedef  IGSetAsListCursor
            <Element, ElementOps> Cursor;


           IGSetAsList
                            (INumber = 100);

           IGSetAsList
                            (IGSetAsList
                              <
                               Element, ElementOps> const&);

  IGSetAsList <Element, ElementOps>&
           operator=        (IGSetAsList
                              <
                               Element, ElementOps> const&);


protected:

           IGSetAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSetAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetAsListCursor
            <Element, ElementOps>;



};

template <class Element>
class ISetAsList :
  public IGSetAsList
          <Element, ICOps <Element> > {

  typedef  IGSetAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISetAsList <Element> Self;

#define ISetAsListTypedef(Element)\
  typedef  ISetAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISetAsList
                            (INumber = 100);


protected:

           ISetAsList
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSetAsList :
  public IGSetAsList
          <Element, ElementOps > {

  typedef  IVGSetAsList
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetAsListTypedef(Element, ElementOps)\
  typedef  ISetAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetAsListTypedef (Element, ElementOps);

public:

           IVGSetAsList
                            (INumber = 100);


protected:

           IVGSetAsList
                              (PureImplementation&);

private:


};

template <class Element>
class IVSetAsList :
  public IVGSetAsList
          <Element, ICOps <Element> > {

  typedef  IVGSetAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSetAsList <Element> Self;

#define IVSetAsListTypedef(Element)\
  typedef  IVSetAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSetAsList
                            (INumber = 100);


protected:

           IVSetAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isetlst.inl>

#pragma info (restore)
#pragma pack ()

#endif
