/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSetAsListCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetAsListCursor <Element, ElementOps>::
IGSetAsListCursor
  (IGSetAsList
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSetAsListCursor <Element, ElementOps>&
IGSetAsListCursor <Element, ElementOps>::
operator=
  (IGSetAsListCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetAsListCursor <Element, ElementOps>::
IGSetAsListCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGSetAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetAsList <Element, ElementOps>::
IGSetAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSetAsList <Element, ElementOps>::
IGSetAsList
  (IGSetAsList
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSetAsList <Element, ElementOps>&
IGSetAsList <Element, ElementOps>::
operator= (IGSetAsList
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetAsList <Element, ElementOps>::
IGSetAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSetAsList
 <Element, ElementOps>::Implementation&
IGSetAsList <Element, ElementOps>::
ImplOf (IGSetAsList
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISetAsList
// ---

// public members

template <class Element>
inline
ISetAsList <Element>::
ISetAsList (INumber numberOfElements)
: IGSetAsList
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISetAsList <Element>::
ISetAsList (PureImplementation& impl)
: IGSetAsList
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSetAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSetAsList <Element, ElementOps>::
IVGSetAsList (INumber numberOfElements)
: IGSetAsList
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSetAsList <Element, ElementOps>::
IVGSetAsList (PureImplementation& impl)
: IGSetAsList
    <Element, ElementOps> (impl)
{
}

// ---
// IVSetAsList
// ---

// public members

template <class Element>
inline
IVSetAsList <Element>::
IVSetAsList (INumber numberOfElements)
: IVGSetAsList
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSetAsList <Element>::
IVSetAsList (PureImplementation& impl)
: IVGSetAsList
   <Element, ICOps <Element> > (impl)
{
}
