#ifndef _ISIZEHDR_
#define _ISIZEHDR_
/*******************************************************************************
* FILE NAME: isizehdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IResizeHandler                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <isizeevt.hpp>

#pragma pack(4)

class IResizeHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
virtual
 ~IResizeHandler ( );

protected:
/*------------------------------- Constructors -------------------------------*/
  IResizeHandler ( );

/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  windowResize ( IResizeEvent& event ) = 0;
}; // IResizeHandler

#pragma pack()

#endif /* _ISIZEHDR_ */
