#ifndef _ISLDAHDR_
   #define _ISLDAHDR_
/*******************************************************************************
* FILE NAME:  isldahdr.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISliderArmHandler                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ictlevt.hpp>

#pragma pack(4)

class ISliderArmHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*-------------------------- Constructors/Destructor -------------------------*/
virtual
  ~ISliderArmHandler ();

protected:
/*------------------------- Protected Constructor(s) -------------------------*/
  ISliderArmHandler  ();

/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  moving          (IControlEvent& event)  ,
  positionChanged (IControlEvent& event)  ;

};  // ISliderArmHandler

#pragma pack()

#endif /* _ISLDAHDR_ */
