#ifndef _ISLHDR_
  #define _ISLHDR_
/*******************************************************************************
* FILE NAME: islhdr.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IShowListHandler                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ictlevt.hpp>

#pragma pack(4)

class IShowListHandler : public IHandler {
typedef IHandler
  Inherited;

public:
/*-------------------------- Constructors ------------------------------------*/
virtual
 ~IShowListHandler ( );


protected:
/*------------------------- Protected Constructors ---------------------------*/
  IShowListHandler ( );

/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  listShown ( IControlEvent& event ) = 0;
}; // IShowListHandler


#pragma pack()

#endif /* _ISLHDR_ */
