/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISMAVL_H
#define _ISMAVL_H

#include <iasm.h>
#include <iicsm.h>
#include <iivsm.h>
#include <iismavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGSortedMapAsAvlTree;

template <class Element, class Key, class ElementOps>
class IGSortedMapAsAvlTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedMapAsAvlTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedMapAsAvlTreeCursor
                            (IGSortedMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsAvlTreeCursor <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsAvlTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedMapAsAvlTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGSortedMapAsAvlTree :
  public IASortedMap <Element, Key> {
protected:

  typedef  IGSortedMapAsAvlTree <Element, Key, ElementOps> Self;

  typedef  ISortedMapAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedMapImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedMapAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedMapAsAvlTreeTypedef (Element, Key, ElementOps);

public:

  typedef  IGSortedMapAsAvlTreeCursor
            <Element, Key, ElementOps> Cursor;


           IGSortedMapAsAvlTree
                            (INumber = 100);

           IGSortedMapAsAvlTree
                            (IGSortedMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsAvlTree <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGSortedMapAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedMapAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedMapAsAvlTreeCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class ISortedMapAsAvlTree :
  public IGSortedMapAsAvlTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedMapAsAvlTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  ISortedMapAsAvlTree <Element, Key> Self;

#define ISortedMapAsAvlTreeTypedef(Element, Key)\
  typedef  ISortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           ISortedMapAsAvlTree
                            (INumber = 100);


protected:

           ISortedMapAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGSortedMapAsAvlTree :
  public IGSortedMapAsAvlTree
          <Element, Key, ElementOps > {

  typedef  IVGSortedMapAsAvlTree
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedMapImpl
            <IVSortedMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedMapAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedMapAsAvlTreeTypedef (Element, Key, ElementOps);

public:

           IVGSortedMapAsAvlTree
                            (INumber = 100);


protected:

           IVGSortedMapAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVSortedMapAsAvlTree :
  public IVGSortedMapAsAvlTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedMapAsAvlTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVSortedMapAsAvlTree <Element, Key> Self;

#define IVSortedMapAsAvlTreeTypedef(Element, Key)\
  typedef  IVSortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVSortedMapAsAvlTree
                            (INumber = 100);


protected:

           IVSortedMapAsAvlTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ismavl.inl>

#pragma info (restore)
#pragma pack ()

#endif
