/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedMapAsBstTreeCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsBstTreeCursor <Element, Key, ElementOps>::
IGSortedMapAsBstTreeCursor
  (IGSortedMapAsBstTree
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsBstTreeCursor <Element, Key, ElementOps>&
IGSortedMapAsBstTreeCursor <Element, Key, ElementOps>::
operator=
  (IGSortedMapAsBstTreeCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsBstTreeCursor <Element, Key, ElementOps>::
IGSortedMapAsBstTreeCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedMapAsBstTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsBstTree <Element, Key, ElementOps>::
IGSortedMapAsBstTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsBstTree <Element, Key, ElementOps>::
IGSortedMapAsBstTree
  (IGSortedMapAsBstTree
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsBstTree <Element, Key, ElementOps>&
IGSortedMapAsBstTree <Element, Key, ElementOps>::
operator= (IGSortedMapAsBstTree
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsBstTree <Element, Key, ElementOps>::
IGSortedMapAsBstTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsBstTree
 <Element, Key, ElementOps>::Implementation&
IGSortedMapAsBstTree <Element, Key, ElementOps>::
ImplOf (IGSortedMapAsBstTree
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedMapAsBstTree
// ---

// public members

template <class Element, class Key>
inline
ISortedMapAsBstTree <Element, Key>::
ISortedMapAsBstTree (INumber numberOfElements)
: IGSortedMapAsBstTree
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
ISortedMapAsBstTree <Element, Key>::
ISortedMapAsBstTree (PureImplementation& impl)
: IGSortedMapAsBstTree
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGSortedMapAsBstTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGSortedMapAsBstTree <Element, Key, ElementOps>::
IVGSortedMapAsBstTree (INumber numberOfElements)
: IGSortedMapAsBstTree
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGSortedMapAsBstTree <Element, Key, ElementOps>::
IVGSortedMapAsBstTree (PureImplementation& impl)
: IGSortedMapAsBstTree
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVSortedMapAsBstTree
// ---

// public members

template <class Element, class Key>
inline
IVSortedMapAsBstTree <Element, Key>::
IVSortedMapAsBstTree (INumber numberOfElements)
: IVGSortedMapAsBstTree
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVSortedMapAsBstTree <Element, Key>::
IVSortedMapAsBstTree (PureImplementation& impl)
: IVGSortedMapAsBstTree
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
