/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISMLST_H
#define _ISMLST_H

#include <iasm.h>
#include <iicsm.h>
#include <iivsm.h>
#include <iismlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGSortedMapAsList;

template <class Element, class Key, class ElementOps>
class IGSortedMapAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedMapAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedMapAsListCursor
                            (IGSortedMapAsList
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsListCursor <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedMapAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGSortedMapAsList :
  public IASortedMap <Element, Key> {
protected:

  typedef  IGSortedMapAsList <Element, Key, ElementOps> Self;

  typedef  ISortedMapAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedMapImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedMapAsListTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedMapAsListTypedef (Element, Key, ElementOps);

public:

  typedef  IGSortedMapAsListCursor
            <Element, Key, ElementOps> Cursor;


           IGSortedMapAsList
                            (INumber = 100);

           IGSortedMapAsList
                            (IGSortedMapAsList
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsList <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsList
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGSortedMapAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedMapAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedMapAsListCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class ISortedMapAsList :
  public IGSortedMapAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedMapAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  ISortedMapAsList <Element, Key> Self;

#define ISortedMapAsListTypedef(Element, Key)\
  typedef  ISortedMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           ISortedMapAsList
                            (INumber = 100);


protected:

           ISortedMapAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGSortedMapAsList :
  public IGSortedMapAsList
          <Element, Key, ElementOps > {

  typedef  IVGSortedMapAsList
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedMapImpl
            <IVSortedMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedMapAsListTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedMapAsListTypedef (Element, Key, ElementOps);

public:

           IVGSortedMapAsList
                            (INumber = 100);


protected:

           IVGSortedMapAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVSortedMapAsList :
  public IVGSortedMapAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedMapAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVSortedMapAsList <Element, Key> Self;

#define IVSortedMapAsListTypedef(Element, Key)\
  typedef  IVSortedMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVSortedMapAsList
                            (INumber = 100);


protected:

           IVSortedMapAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ismlst.inl>

#pragma info (restore)
#pragma pack ()

#endif
