/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedMapAsTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsTableCursor <Element, Key, ElementOps>::
IGSortedMapAsTableCursor
  (IGSortedMapAsTable
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsTableCursor <Element, Key, ElementOps>&
IGSortedMapAsTableCursor <Element, Key, ElementOps>::
operator=
  (IGSortedMapAsTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsTableCursor <Element, Key, ElementOps>::
IGSortedMapAsTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedMapAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsTable <Element, Key, ElementOps>::
IGSortedMapAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsTable <Element, Key, ElementOps>::
IGSortedMapAsTable
  (IGSortedMapAsTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsTable <Element, Key, ElementOps>&
IGSortedMapAsTable <Element, Key, ElementOps>::
operator= (IGSortedMapAsTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsTable <Element, Key, ElementOps>::
IGSortedMapAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsTable
 <Element, Key, ElementOps>::Implementation&
IGSortedMapAsTable <Element, Key, ElementOps>::
ImplOf (IGSortedMapAsTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedMapAsTable
// ---

// public members

template <class Element, class Key>
inline
ISortedMapAsTable <Element, Key>::
ISortedMapAsTable (INumber numberOfElements)
: IGSortedMapAsTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
ISortedMapAsTable <Element, Key>::
ISortedMapAsTable (PureImplementation& impl)
: IGSortedMapAsTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGSortedMapAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGSortedMapAsTable <Element, Key, ElementOps>::
IVGSortedMapAsTable (INumber numberOfElements)
: IGSortedMapAsTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGSortedMapAsTable <Element, Key, ElementOps>::
IVGSortedMapAsTable (PureImplementation& impl)
: IGSortedMapAsTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVSortedMapAsTable
// ---

// public members

template <class Element, class Key>
inline
IVSortedMapAsTable <Element, Key>::
IVSortedMapAsTable (INumber numberOfElements)
: IVGSortedMapAsTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVSortedMapAsTable <Element, Key>::
IVSortedMapAsTable (PureImplementation& impl)
: IVGSortedMapAsTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
