/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISRLST_H
#define _ISRLST_H

#include <iasr.h>
#include <iicsr.h>
#include <iivsr.h>
#include <iisrlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsList;

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedRelationAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedRelationAsListCursor
                            (IGSortedRelationAsList
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationAsListCursor <Element, Key, ElementOps>&
           operator=        (IGSortedRelationAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedRelationAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsList :
  public IASortedRelation <Element, Key> {
protected:

  typedef  IGSortedRelationAsList <Element, Key, ElementOps> Self;

  typedef  ISortedRelationAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedRelationAsListTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedRelationAsListTypedef (Element, Key, ElementOps);

public:

  typedef  IGSortedRelationAsListCursor
            <Element, Key, ElementOps> Cursor;


           IGSortedRelationAsList
                            (INumber = 100);

           IGSortedRelationAsList
                            (IGSortedRelationAsList
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationAsList <Element, Key, ElementOps>&
           operator=        (IGSortedRelationAsList
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGSortedRelationAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedRelationAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedRelationAsListCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class ISortedRelationAsList :
  public IGSortedRelationAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedRelationAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  ISortedRelationAsList <Element, Key> Self;

#define ISortedRelationAsListTypedef(Element, Key)\
  typedef  ISortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           ISortedRelationAsList
                            (INumber = 100);


protected:

           ISortedRelationAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGSortedRelationAsList :
  public IGSortedRelationAsList
          <Element, Key, ElementOps > {

  typedef  IVGSortedRelationAsList
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedRelationImpl
            <IVSortedRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedRelationAsListTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedRelationAsListTypedef (Element, Key, ElementOps);

public:

           IVGSortedRelationAsList
                            (INumber = 100);


protected:

           IVGSortedRelationAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVSortedRelationAsList :
  public IVGSortedRelationAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedRelationAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVSortedRelationAsList <Element, Key> Self;

#define IVSortedRelationAsListTypedef(Element, Key)\
  typedef  IVSortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVSortedRelationAsList
                            (INumber = 100);


protected:

           IVSortedRelationAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isrlst.inl>

#pragma info (restore)
#pragma pack ()

#endif
