/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISS_H
#define _ISS_H

#include <iass.h>
#include <iicss.h>
#include <iivss.h>
#include <iissavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSortedSet;

template <class Element, class ElementOps>
class IGSortedSetCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedSet
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedSetCursor
                            (IGSortedSet
                              <
                               Element, ElementOps> const&);

  IGSortedSetCursor <Element, ElementOps>&
           operator=        (IGSortedSetCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedSetCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSortedSet :
  public IASortedSet <Element> {
protected:

  typedef  IGSortedSet <Element, ElementOps> Self;

  typedef  ISortedSetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedSetTypedef(Element, ElementOps)\
  typedef  ISortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedSetTypedef (Element, ElementOps);

public:

  typedef  IGSortedSetCursor
            <Element, ElementOps> Cursor;


           IGSortedSet
                            (INumber = 100);

           IGSortedSet
                            (IGSortedSet
                              <
                               Element, ElementOps> const&);

  IGSortedSet <Element, ElementOps>&
           operator=        (IGSortedSet
                              <
                               Element, ElementOps> const&);


protected:

           IGSortedSet
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedSet
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedSetCursor
            <Element, ElementOps>;



};

template <class Element>
class ISortedSet :
  public IGSortedSet
          <Element, ICOps <Element> > {

  typedef  IGSortedSet
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISortedSet <Element> Self;

#define ISortedSetTypedef(Element)\
  typedef  ISortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISortedSet
                            (INumber = 100);


protected:

           ISortedSet
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSortedSet :
  public IGSortedSet
          <Element, ElementOps > {

  typedef  IVGSortedSet
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedSetImpl
            <IVSortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedSetTypedef(Element, ElementOps)\
  typedef  ISortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedSetTypedef (Element, ElementOps);

public:

           IVGSortedSet
                            (INumber = 100);


protected:

           IVGSortedSet
                              (PureImplementation&);

private:


};

template <class Element>
class IVSortedSet :
  public IVGSortedSet
          <Element, ICOps <Element> > {

  typedef  IVGSortedSet
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSortedSet <Element> Self;

#define IVSortedSetTypedef(Element)\
  typedef  IVSortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSortedSet
                            (INumber = 100);


protected:

           IVSortedSet
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iss.inl>

#pragma info (restore)
#pragma pack ()

#endif
