/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedSetCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedSetCursor <Element, ElementOps>::
IGSortedSetCursor
  (IGSortedSet
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSortedSetCursor <Element, ElementOps>&
IGSortedSetCursor <Element, ElementOps>::
operator=
  (IGSortedSetCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedSetCursor <Element, ElementOps>::
IGSortedSetCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedSet
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedSet <Element, ElementOps>::
IGSortedSet (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSortedSet <Element, ElementOps>::
IGSortedSet
  (IGSortedSet
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSortedSet <Element, ElementOps>&
IGSortedSet <Element, ElementOps>::
operator= (IGSortedSet
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedSet <Element, ElementOps>::
IGSortedSet (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSortedSet
 <Element, ElementOps>::Implementation&
IGSortedSet <Element, ElementOps>::
ImplOf (IGSortedSet
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedSet
// ---

// public members

template <class Element>
inline
ISortedSet <Element>::
ISortedSet (INumber numberOfElements)
: IGSortedSet
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISortedSet <Element>::
ISortedSet (PureImplementation& impl)
: IGSortedSet
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSortedSet
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSortedSet <Element, ElementOps>::
IVGSortedSet (INumber numberOfElements)
: IGSortedSet
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSortedSet <Element, ElementOps>::
IVGSortedSet (PureImplementation& impl)
: IGSortedSet
    <Element, ElementOps> (impl)
{
}

// ---
// IVSortedSet
// ---

// public members

template <class Element>
inline
IVSortedSet <Element>::
IVSortedSet (INumber numberOfElements)
: IVGSortedSet
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSortedSet <Element>::
IVSortedSet (PureImplementation& impl)
: IVGSortedSet
   <Element, ICOps <Element> > (impl)
{
}
