/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISSBST_H
#define _ISSBST_H

#include <iass.h>
#include <iicss.h>
#include <iivss.h>
#include <iissbst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSortedSetAsBstTree;

template <class Element, class ElementOps>
class IGSortedSetAsBstTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedSetAsBstTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedSetAsBstTreeCursor
                            (IGSortedSetAsBstTree
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsBstTreeCursor <Element, ElementOps>&
           operator=        (IGSortedSetAsBstTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedSetAsBstTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSortedSetAsBstTree :
  public IASortedSet <Element> {
protected:

  typedef  IGSortedSetAsBstTree <Element, ElementOps> Self;

  typedef  ISortedSetAsBstTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedSetAsBstTreeTypedef(Element, ElementOps)\
  typedef  ISortedSetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedSetAsBstTreeTypedef (Element, ElementOps);

public:

  typedef  IGSortedSetAsBstTreeCursor
            <Element, ElementOps> Cursor;


           IGSortedSetAsBstTree
                            (INumber = 100);

           IGSortedSetAsBstTree
                            (IGSortedSetAsBstTree
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsBstTree <Element, ElementOps>&
           operator=        (IGSortedSetAsBstTree
                              <
                               Element, ElementOps> const&);


protected:

           IGSortedSetAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedSetAsBstTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedSetAsBstTreeCursor
            <Element, ElementOps>;



};

template <class Element>
class ISortedSetAsBstTree :
  public IGSortedSetAsBstTree
          <Element, ICOps <Element> > {

  typedef  IGSortedSetAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISortedSetAsBstTree <Element> Self;

#define ISortedSetAsBstTreeTypedef(Element)\
  typedef  ISortedSetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISortedSetAsBstTree
                            (INumber = 100);


protected:

           ISortedSetAsBstTree
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSortedSetAsBstTree :
  public IGSortedSetAsBstTree
          <Element, ElementOps > {

  typedef  IVGSortedSetAsBstTree
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedSetImpl
            <IVSortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedSetAsBstTreeTypedef(Element, ElementOps)\
  typedef  ISortedSetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedSetAsBstTreeTypedef (Element, ElementOps);

public:

           IVGSortedSetAsBstTree
                            (INumber = 100);


protected:

           IVGSortedSetAsBstTree
                              (PureImplementation&);

private:


};

template <class Element>
class IVSortedSetAsBstTree :
  public IVGSortedSetAsBstTree
          <Element, ICOps <Element> > {

  typedef  IVGSortedSetAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSortedSetAsBstTree <Element> Self;

#define IVSortedSetAsBstTreeTypedef(Element)\
  typedef  IVSortedSetAsBstTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSortedSetAsBstTree
                            (INumber = 100);


protected:

           IVSortedSetAsBstTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <issbst.inl>

#pragma info (restore)
#pragma pack ()

#endif
