/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISSDIL_H
#define _ISSDIL_H

#include <iass.h>
#include <iicss.h>
#include <iivss.h>
#include <iissdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSortedSetAsDilTable;

template <class Element, class ElementOps>
class IGSortedSetAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedSetAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedSetAsDilTableCursor
                            (IGSortedSetAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsDilTableCursor <Element, ElementOps>&
           operator=        (IGSortedSetAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedSetAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSortedSetAsDilTable :
  public IASortedSet <Element> {
protected:

  typedef  IGSortedSetAsDilTable <Element, ElementOps> Self;

  typedef  ISortedSetAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedSetAsDilTableTypedef(Element, ElementOps)\
  typedef  ISortedSetAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedSetAsDilTableTypedef (Element, ElementOps);

public:

  typedef  IGSortedSetAsDilTableCursor
            <Element, ElementOps> Cursor;


           IGSortedSetAsDilTable
                            (INumber = 100);

           IGSortedSetAsDilTable
                            (IGSortedSetAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsDilTable <Element, ElementOps>&
           operator=        (IGSortedSetAsDilTable
                              <
                               Element, ElementOps> const&);


protected:

           IGSortedSetAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedSetAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedSetAsDilTableCursor
            <Element, ElementOps>;



};

template <class Element>
class ISortedSetAsDilTable :
  public IGSortedSetAsDilTable
          <Element, ICOps <Element> > {

  typedef  IGSortedSetAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISortedSetAsDilTable <Element> Self;

#define ISortedSetAsDilTableTypedef(Element)\
  typedef  ISortedSetAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISortedSetAsDilTable
                            (INumber = 100);


protected:

           ISortedSetAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSortedSetAsDilTable :
  public IGSortedSetAsDilTable
          <Element, ElementOps > {

  typedef  IVGSortedSetAsDilTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedSetImpl
            <IVSortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedSetAsDilTableTypedef(Element, ElementOps)\
  typedef  ISortedSetAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedSetAsDilTableTypedef (Element, ElementOps);

public:

           IVGSortedSetAsDilTable
                            (INumber = 100);


protected:

           IVGSortedSetAsDilTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVSortedSetAsDilTable :
  public IVGSortedSetAsDilTable
          <Element, ICOps <Element> > {

  typedef  IVGSortedSetAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSortedSetAsDilTable <Element> Self;

#define IVSortedSetAsDilTableTypedef(Element)\
  typedef  IVSortedSetAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSortedSetAsDilTable
                            (INumber = 100);


protected:

           IVSortedSetAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <issdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
