/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedSetAsListCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedSetAsListCursor <Element, ElementOps>::
IGSortedSetAsListCursor
  (IGSortedSetAsList
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSortedSetAsListCursor <Element, ElementOps>&
IGSortedSetAsListCursor <Element, ElementOps>::
operator=
  (IGSortedSetAsListCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedSetAsListCursor <Element, ElementOps>::
IGSortedSetAsListCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedSetAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedSetAsList <Element, ElementOps>::
IGSortedSetAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSortedSetAsList <Element, ElementOps>::
IGSortedSetAsList
  (IGSortedSetAsList
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSortedSetAsList <Element, ElementOps>&
IGSortedSetAsList <Element, ElementOps>::
operator= (IGSortedSetAsList
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedSetAsList <Element, ElementOps>::
IGSortedSetAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSortedSetAsList
 <Element, ElementOps>::Implementation&
IGSortedSetAsList <Element, ElementOps>::
ImplOf (IGSortedSetAsList
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedSetAsList
// ---

// public members

template <class Element>
inline
ISortedSetAsList <Element>::
ISortedSetAsList (INumber numberOfElements)
: IGSortedSetAsList
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISortedSetAsList <Element>::
ISortedSetAsList (PureImplementation& impl)
: IGSortedSetAsList
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSortedSetAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSortedSetAsList <Element, ElementOps>::
IVGSortedSetAsList (INumber numberOfElements)
: IGSortedSetAsList
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSortedSetAsList <Element, ElementOps>::
IVGSortedSetAsList (PureImplementation& impl)
: IGSortedSetAsList
    <Element, ElementOps> (impl)
{
}

// ---
// IVSortedSetAsList
// ---

// public members

template <class Element>
inline
IVSortedSetAsList <Element>::
IVSortedSetAsList (INumber numberOfElements)
: IVGSortedSetAsList
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSortedSetAsList <Element>::
IVSortedSetAsList (PureImplementation& impl)
: IVGSortedSetAsList
   <Element, ICOps <Element> > (impl)
{
}
