/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISSTAB_H
#define _ISSTAB_H

#include <iass.h>
#include <iicss.h>
#include <iivss.h>
#include <iisstab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSortedSetAsTable;

template <class Element, class ElementOps>
class IGSortedSetAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedSetAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedSetAsTableCursor
                            (IGSortedSetAsTable
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsTableCursor <Element, ElementOps>&
           operator=        (IGSortedSetAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedSetAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSortedSetAsTable :
  public IASortedSet <Element> {
protected:

  typedef  IGSortedSetAsTable <Element, ElementOps> Self;

  typedef  ISortedSetAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedSetAsTableTypedef(Element, ElementOps)\
  typedef  ISortedSetAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedSetAsTableTypedef (Element, ElementOps);

public:

  typedef  IGSortedSetAsTableCursor
            <Element, ElementOps> Cursor;


           IGSortedSetAsTable
                            (INumber = 100);

           IGSortedSetAsTable
                            (IGSortedSetAsTable
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsTable <Element, ElementOps>&
           operator=        (IGSortedSetAsTable
                              <
                               Element, ElementOps> const&);


protected:

           IGSortedSetAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedSetAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedSetAsTableCursor
            <Element, ElementOps>;



};

template <class Element>
class ISortedSetAsTable :
  public IGSortedSetAsTable
          <Element, ICOps <Element> > {

  typedef  IGSortedSetAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISortedSetAsTable <Element> Self;

#define ISortedSetAsTableTypedef(Element)\
  typedef  ISortedSetAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISortedSetAsTable
                            (INumber = 100);


protected:

           ISortedSetAsTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSortedSetAsTable :
  public IGSortedSetAsTable
          <Element, ElementOps > {

  typedef  IVGSortedSetAsTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedSetImpl
            <IVSortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedSetAsTableTypedef(Element, ElementOps)\
  typedef  ISortedSetAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedSetAsTableTypedef (Element, ElementOps);

public:

           IVGSortedSetAsTable
                            (INumber = 100);


protected:

           IVGSortedSetAsTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVSortedSetAsTable :
  public IVGSortedSetAsTable
          <Element, ICOps <Element> > {

  typedef  IVGSortedSetAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSortedSetAsTable <Element> Self;

#define IVSortedSetAsTableTypedef(Element)\
  typedef  IVSortedSetAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSortedSetAsTable
                            (INumber = 100);


protected:

           IVSortedSetAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isstab.inl>

#pragma info (restore)
#pragma pack ()

#endif
