/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedSetAsTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedSetAsTableCursor <Element, ElementOps>::
IGSortedSetAsTableCursor
  (IGSortedSetAsTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSortedSetAsTableCursor <Element, ElementOps>&
IGSortedSetAsTableCursor <Element, ElementOps>::
operator=
  (IGSortedSetAsTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedSetAsTableCursor <Element, ElementOps>::
IGSortedSetAsTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedSetAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedSetAsTable <Element, ElementOps>::
IGSortedSetAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSortedSetAsTable <Element, ElementOps>::
IGSortedSetAsTable
  (IGSortedSetAsTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSortedSetAsTable <Element, ElementOps>&
IGSortedSetAsTable <Element, ElementOps>::
operator= (IGSortedSetAsTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedSetAsTable <Element, ElementOps>::
IGSortedSetAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSortedSetAsTable
 <Element, ElementOps>::Implementation&
IGSortedSetAsTable <Element, ElementOps>::
ImplOf (IGSortedSetAsTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedSetAsTable
// ---

// public members

template <class Element>
inline
ISortedSetAsTable <Element>::
ISortedSetAsTable (INumber numberOfElements)
: IGSortedSetAsTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISortedSetAsTable <Element>::
ISortedSetAsTable (PureImplementation& impl)
: IGSortedSetAsTable
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSortedSetAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSortedSetAsTable <Element, ElementOps>::
IVGSortedSetAsTable (INumber numberOfElements)
: IGSortedSetAsTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSortedSetAsTable <Element, ElementOps>::
IVGSortedSetAsTable (PureImplementation& impl)
: IGSortedSetAsTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVSortedSetAsTable
// ---

// public members

template <class Element>
inline
IVSortedSetAsTable <Element>::
IVSortedSetAsTable (INumber numberOfElements)
: IVGSortedSetAsTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSortedSetAsTable <Element>::
IVSortedSetAsTable (PureImplementation& impl)
: IVGSortedSetAsTable
   <Element, ICOps <Element> > (impl)
{
}
