#ifndef _ISTATNRY_INL_
#define _ISTATNRY_INL_ 0
/*******************************************************************************
* FILE NAME: istatnry.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in istatnry.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _ISTATNRY_
  #undef  _ISTATNRY_INL_
  #define _ISTATNRY_INL_ 1
  #include <istatnry.hpp>
#endif

#if _ISTATNRY_INL_
  #define inline
#endif


//===============================================================================
//
// inline members of class IComponentStationery
//

inline
IGUIBundle&
IComponentStationery::bundle() const
{ 
    return *fpBundle;
}

inline
const IString&
IComponentStationery::appName() const
{
    return fstrAppName;
}

inline
const IString&
IComponentStationery::fileExt() const
{
    return fstrFileExt;
}

inline
const IString&
IComponentStationery::shortName() const
{
    return fstrShortName;
}

inline
Boolean
IComponentStationery::isEmbedded() const
{
    return fbEmbedded;
}

inline
Boolean
IComponentStationery::isServer() const
{
    return true;
}

inline
CAswControl&
IComponentStationery::control() const
{
    return *fpAswControl;
}

inline
IComponentStationery::operator CAswControl* () const
{
    return &control();
}

inline
IComponentFactory&
IComponentStationery::componentFactory() const
{
    return *fpComponentFactory;
}

inline
IAswClipboardSource&
IComponentStationery::clipSource() const
{
    return *fpClipSource;
}

inline
IAswPasteTarget&
IComponentStationery::pasteTarget() const
{
    return *fpPasteTarget;
}

inline
IAswDragSource&
IComponentStationery::dragSource() const
{
    return *fpDragSource;
}

inline
CLIPFORMAT
IComponentStationery::cfEmbeddedObject() const
{
    return fcfEmbeddedObject;
}

inline
CLIPFORMAT
IComponentStationery::cfObjectDescriptor() const
{ 
    return fcfObjectDescriptor;
}

inline
CLIPFORMAT
IComponentStationery::cfLinkSource() const
{
    return fcfLinkSource;
}

inline
CLIPFORMAT
IComponentStationery::cfLinkSrcDescriptor() const
{ 
    return fcfLinkSrcDescriptor;
}

#endif /* _ISTATNRY_INL_ */

