#ifndef _ISTATTXT_
  #define _ISTATTXT_
/*******************************************************************************
* FILE NAME: istattxt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IStaticText                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <icolor.hpp>
#include <irect.hpp>
 #include <ihandler.hpp>

#pragma pack(4)

class ISize;
class IStaticTextHandler;
class IStaticTextData;
class IStaticHandler;

class IStaticText : public ITextControl {
typedef ITextControl
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IStaticText ( unsigned long        id,
                IWindow*             parent,
                IWindow*             owner,
                const IRectangle&    initial = IRectangle(),
                const Style&         style   = defaultStyle() );

  IStaticText ( unsigned long        id,
                IWindow*             parent );

  IStaticText ( const IWindowHandle& handle );

virtual
 ~IStaticText ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2 ( Style,
                          IStaticText,
                          IWindow,
                          IControl );
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU left,
  IC_IMPORTU center,
  IC_IMPORTU right,
  IC_IMPORTU wordBreak,
  IC_IMPORTU mnemonic,
  IC_IMPORTU top,
  IC_IMPORTU vertCenter,
  IC_IMPORTU bottom,
  IC_IMPORTU halftone,
  IC_IMPORTU underscore,
  IC_IMPORTU strikeout,
  IC_IMPORTU fillBackground,
#ifndef IC_MOTIFPM_FLAGNOP
  IC_IMPORTU border3D;
#endif

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------------- Alignment ----------------------------------*/
enum Alignment {
  topLeft,
  topLeftWrapped,
  topCenter,
  topRight,
  centerLeft,
  centerCenter,
  centerRight,
  bottomLeft,
  bottomCenter,
  bottomRight
};

virtual IStaticText
 &setAlignment ( Alignment alignment = IStaticText::topLeft );

Alignment
  alignment    ( ) const;

/*------------------------- Style Functions ----------------------------------*/
virtual IStaticText
 &enableStrikeout       ( Boolean enable = true ),
 &disableStrikeout      ( ),
 &enableUnderscore      ( Boolean enable = true ),
 &disableUnderscore     ( ),
 &enableHalftone        ( Boolean enable = true ),
 &disableHalftone       ( ),
 &enableFillBackground  ( Boolean enable = true ),
 &disableFillBackground ( );

Boolean
  isStrikeout           ( ) const,
  isUnderscore          ( ) const,
  isHalftone            ( ) const,
  hasFillBackground     ( ) const;

/*---------------------------------- Colors ----------------------------------*/
virtual IColor
  foregroundColor ( ) const,
  backgroundColor ( ) const;

virtual IColor
  fillColor       ( ) const;

virtual IStaticText
 &setFillColor    ( const IColor& color ),
 &resetFillColor  ( );

/*-------------------------- Minimum Size Adjustment -------------------------*/
virtual IStaticText
 &setLimit ( unsigned long limit = 0 );

unsigned long
  limit    ( ) const;

/*------------------------------ Text Processing -----------------------------*/
virtual IStaticText
 &setText ( const char*        text ),
 &setText ( const IResourceId& text );

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU strikeoutId,
  IC_IMPORTU underscoreId,
  IC_IMPORTU halftoneId,
  IC_IMPORTU fillColorId,
  IC_IMPORTU fillBackgroundId,
  IC_IMPORTU limitId;

/*----------------------------- Window Positioning ---------------------------*/


protected:
/*------------------------------ Layout Support ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const,
  calcLimitSize   ( ) const;

/*---------------------- Event-Handling Implementation -----------------------*/

IStaticText
 &addDrawingHandler( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IStaticText ( const IStaticText& );
IStaticText
 &operator=   ( const IStaticText& );

void
  notify      ( INotificationId nId,
                Boolean enabled );

/*--------------------------------- Private ----------------------------------*/
friend class IStaticTextHandler;
friend class IStaticHandler;

static Style
  currentDefaultStyle;

unsigned long
  ulClLimit;

IStaticTextData
 *fStaticTextData;

}; // class IStaticText

INESTEDBITFLAGCLASSFUNCS(Style, IStaticText);
                                  // global style functions

#pragma pack()

/*--------------------------------- Inlines ----------------------------------*/
  #include <istattxt.inl>

#endif  // _ISTATTXT_
