/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <string.h>

// -------------
// elementForOps
// -------------

template <class Element>
inline Element& elementForOps (Element& e)
{ return e;
}

template <class Element>
inline Element const& elementForOps (Element const& e)
{ return e;
}

// ----------
// IStdMemOps
// ----------

inline void*
IStdMemOps::
allocate (size_t s
#if defined (__DEBUG_ALLOC__)
          , char const* fn, unsigned long ln
#endif
         ) const
{
    return ::operator new (s
#if defined (__DEBUG_ALLOC__)
                           , fn, ln
#endif
                          );
}

inline void
IStdMemOps::
deallocate (void* p
#if defined (__DEBUG_ALLOC__)
            , char const* fn, unsigned long ln
#endif
           ) const
{ ::operator delete (p
#if defined (__DEBUG_ALLOC__)
                     , fn, ln
#endif
                    );
}

template <class ElementOps>
inline void*
IWStdMemOps <ElementOps>::
Allocate (size_t s
#if defined (__DEBUG_ALLOC__)
          , char const* fn, unsigned long ln
#endif
         ) const
{ return ivElementOps.allocate (s
#if defined (__DEBUG_ALLOC__)
                                , fn, ln
#endif
                               );
}

template <class ElementOps>
inline void
IWStdMemOps <ElementOps>::
Deallocate (void* p
#if defined (__DEBUG_ALLOC__)
            , char const* fn, unsigned long ln
#endif
           ) const
{ ivElementOps.deallocate (p
#if defined (__DEBUG_ALLOC__)
                           , fn, ln
#endif
                          );
}

// ---------
// IStdAsOps
// ---------

template <class Element>
inline void
assign (Element& e1, Element const& e2)
{ e1 = e2;
}

// public members

template <class Element>
inline void
IStdAsOps <Element>::
assign (Element& e1, Element const& e2) const
{ ::assign (e1, e2);
}

template <class Element, class ElementOps>
inline void
IWStdAsOps <Element, ElementOps>::
Assign (Element& e1, Element const& e2) const
{ ivElementOps.assign (e1, e2);
}

// ---------
// IStdEqOps
// ---------

template <class Element>
inline IBoolean
equal (Element const& e1, Element const& e2)
{ return (e1 == e2);
}

inline IBoolean
equal (char const* e1, char const* e2)
{ return (strcmp (e1, e2) == 0);
}

// public members

template <class Element>
inline IBoolean
IStdEqOps <Element>::
equal (Element const& e1, Element const& e2) const
{ return ::equal (elementForOps (e1), elementForOps (e2));
}

template <class Element, class ElementOps>
inline IBoolean
IWStdEqOps <Element, ElementOps>::
Equal (Element const& e1, Element const& e2) const
{ return ivElementOps.equal (e1, e2);
}

template <class Key, class ElementOps>
inline IBoolean
IWStdEqKeyOps <Key, ElementOps>::
Equal (Key const& k1, Key const& k2) const
{ return ivElementOps.keyOps.equal (k1, k2);
}

// ----------
// IStdCmpOps
// ----------

template <class Element>
inline long
compare (Element const& e1, Element const& e2)
{ if      (e1 < e2) return -1;
  else if (e2 < e1) return  1;
  else              return  0;
}

inline long
compare (int e1, int e2)
{ return (e1 - e2);
}

inline long
compare (char const* e1, char const* e2)
{ return strcmp (e1, e2);
}

// public members

template <class Element>
inline long
IStdCmpOps <Element>::
compare (Element const& e1, Element const& e2) const
{ return ::compare (elementForOps (e1), elementForOps (e2));
}

template <class Element, class ElementOps>
inline long
IWStdCmpOps <Element, ElementOps>::
Compare (Element const& e1, Element const& e2) const
{ return ivElementOps.compare (e1, e2);
}

template <class Key, class ElementOps>
inline long
IWStdCmpKeyOps <Key, ElementOps>::
Compare (Key const& k1, Key const& k2) const
{ return ivElementOps.keyOps.compare (k1, k2);
}

// ----------
// IStdHshOps
// ----------

inline unsigned long
hash (int e, unsigned long h)
{ return e % h;
}

inline unsigned long
hash (char const* s, unsigned long h)
{ unsigned long hashValue = 0, g;
  for (char* p = (char*)s; *p != '\0'; p++) {
    hashValue = (hashValue << 4) + *p;
    if ((g = hashValue & 0xf0000000L) != 0) {
      hashValue ^= (g >> 24);
      hashValue ^= g;
    }
  }
  return hashValue % h;
} // see: Aho, Sethi, Ullman
  //      "Compilers: Principles, Techniques, and Tools"

// public members

template <class Element>
inline unsigned long
IStdHshOps <Element>::
hash (Element const& e, unsigned long h) const
{ return ::hash (elementForOps (e), h);
}

template <class Element, class ElementOps>
inline unsigned long
IWStdHshOps <Element, ElementOps>::
Hash (Element const& e, unsigned long h) const
{ return ivElementOps.hash (e, h);
}

template <class Key, class ElementOps>
inline unsigned long
IWStdHshKeyOps <Key, ElementOps>::
Hash (Key const& k, unsigned long h) const
{ return ivElementOps.keyOps.hash (k, h);
}

// ----------
// IStdKeyOps
// ----------

// public members

template <class Element, class Key>
inline Key const&
IStdKeyOps <Element, Key>::
key (Element const& e) const
{ return ::key (elementForOps (e));
}

template <class Element, class _Key, class ElementOps>
inline _Key const&
IWStdKeyOps <Element, _Key, ElementOps>::
Key (Element const& e) const
{ return ivElementOps.key (e);
}

// -----------------
// IStdOpsSubstitute
// -----------------

// public members

template <class Element, class ElementOps>
inline TStream&
IWStdOps <Element, ElementOps>::
operator<<= (TStream& fromWhere)
{ return fromWhere;
}

template <class Element, class ElementOps>
inline TStream&
IWStdOps <Element, ElementOps>::
operator>>= (TStream& toWhere) const
{ return toWhere;
}

template <class Element, class ElementOps>
inline void
IWStdOps <Element, ElementOps>::
StreamIn (Element&, TStream&) const
{
}

template <class Element, class ElementOps>
inline void
IWStdOps <Element, ElementOps>::
StreamOut (Element const&, TStream&) const
{
}

template <class Element, class ElementOps>
inline Element*
IWStdOps <Element, ElementOps>::
GetStreamable ()
{ return 0;
}
