/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGStackAsTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGStackAsTableCursor <Element, ElementOps>::
IGStackAsTableCursor
  (IGStackAsTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGStackAsTableCursor <Element, ElementOps>&
IGStackAsTableCursor <Element, ElementOps>::
operator=
  (IGStackAsTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGStackAsTableCursor <Element, ElementOps>::
IGStackAsTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGStackAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGStackAsTable <Element, ElementOps>::
IGStackAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGStackAsTable <Element, ElementOps>::
IGStackAsTable
  (IGStackAsTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGStackAsTable <Element, ElementOps>&
IGStackAsTable <Element, ElementOps>::
operator= (IGStackAsTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGStackAsTable <Element, ElementOps>::
IGStackAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGStackAsTable
 <Element, ElementOps>::Implementation&
IGStackAsTable <Element, ElementOps>::
ImplOf (IGStackAsTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IStackAsTable
// ---

// public members

template <class Element>
inline
IStackAsTable <Element>::
IStackAsTable (INumber numberOfElements)
: IGStackAsTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IStackAsTable <Element>::
IStackAsTable (PureImplementation& impl)
: IGStackAsTable
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGStackAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGStackAsTable <Element, ElementOps>::
IVGStackAsTable (INumber numberOfElements)
: IGStackAsTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGStackAsTable <Element, ElementOps>::
IVGStackAsTable (PureImplementation& impl)
: IGStackAsTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVStackAsTable
// ---

// public members

template <class Element>
inline
IVStackAsTable <Element>::
IVStackAsTable (INumber numberOfElements)
: IVGStackAsTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVStackAsTable <Element>::
IVStackAsTable (PureImplementation& impl)
: IVGStackAsTable
   <Element, IStdOps <Element> > (impl)
{
}
