

#ifndef _ISTPARSE_
#define _ISTPARSE_
/*******************************************************************************
* FILE NAME: istparse.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IStringParser                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>



class IString;
class IStringTest;
class IStringParserData;

class IStringParser : public IBase {
typedef IBase
  Inherited;
public:

/*------------------------- Constructors -------------------------------------*/
 ~IStringParser ( );

/*------------------------- Commands -----------------------------------------*/
enum Command {
  reset,
  skipWord
};

class SkipWords : public IBase {
public:
  SkipWords     ( unsigned long numberOfWords = 1 );
unsigned long
  numberOfWords ( ) const;
private:
unsigned long
  fNumSkip;


};

IStringParser
 &operator >>   ( Command          command ),
 &operator >>   ( const SkipWords& skipObject );

/*------------------------- Initialize ---------------------------------------*/
friend IStringParser
  operator >>   ( const IString& text,
                        IString& token );

friend IStringParser
  operator >>   ( const IString& text,
                  const IString& pattern );
friend IStringParser
  operator >>   ( const IString& text,
                  const char*    pattern );

friend IStringParser
  operator >>   ( const IString& text,
                  char           pattern );

friend IStringParser
  operator >>   ( const IString& text,
                  unsigned long  position );
friend IStringParser
  operator >>   ( const IString& text,
                  int            position );

friend IStringParser
  operator <<   ( const IString& text,
                  unsigned long  position );

friend IStringParser
  operator >>   ( const IString&     text,
                  const IStringTest& test );

friend IStringParser
  operator >>   ( const IString&         text,
                  IStringParser::Command command );

friend IStringParser
  operator >>   ( const IString&                  text,
                  const IStringParser::SkipWords& skipObject );

/*------------------------- Tokenizing ---------------------------------------*/
IStringParser
 &operator >>   ( IString& token );

/*------------------------- Pattern Matching ---------------------------------*/
IStringParser
 &operator >>   ( const IString&     pattern ),
 &operator >>   ( const char*        pattern ),
 &operator >>   ( char               pattern ),
 &operator >>   ( const IStringTest& test );

/*----------------------- Relative Column Positioning ------------------------*/
IStringParser
 &operator >>   ( int           delta ),
 &operator >>   ( unsigned long delta );

/*----------------------- Absolute Column Positioning ------------------------*/
IStringParser
 &operator <<   ( unsigned long position );


protected:
/*------------------------- Protected Constructors ---------------------------*/
  IStringParser ( const IString&       text );
  IStringParser ( const IStringParser& parser );


/*------------------------- Private ------------------------------------------*/
private:
IStringParserData
 *fData;




}; // class IStringParser



#endif // _ISTPARSE_


