/*******************************************************************************
* FILE NAME: istrgen.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in istrgen.hpp.                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <istrgen.hpp>


template <class T>
  IStringGeneratorMemberFn<T> ::
    IStringGeneratorMemberFn ( IString ( T :: *member )( ) )
    : memberFunction( member )
{
}

template <class T>
  IStringGeneratorMemberFn<T> ::
   ~IStringGeneratorMemberFn ( )
{
}

template <class T>
  IString  IStringGeneratorMemberFn<T> :: stringFor ( const T& object )
{
  T *  pobject = (T *)&object;
  return (pobject->*memberFunction)( );
}

template <class T, class U>
  IStringGeneratorRefMemberFn<T,U> ::
    IStringGeneratorRefMemberFn ( IString ( U :: *member )( ) )
    : memberFunction( member )
{
}

template <class T, class U>
  IStringGeneratorRefMemberFn<T,U> ::
   ~IStringGeneratorRefMemberFn ( )
{
}

template <class T, class U>
  IString  IStringGeneratorRefMemberFn<T,U> :: stringFor ( const T& object )
{
  return  (object->*memberFunction)( );
}


template <class Element>
  IStringGenerator<Element> ::
    IStringGenerator( const IReference < IStringGeneratorFn<Element> >&
                         generatorFunction )
    : fgeneratorFunction( generatorFunction )
{
  if ( fgeneratorFunction )
    fgeneratorFunction->addRef( );
}


template <class Element>
  IStringGenerator<Element> ::
    IStringGenerator( const IStringGenerator<Element>&
                         stringGenerator )
    : fgeneratorFunction( stringGenerator.fgeneratorFunction )
{
}


template <class Element>
  IStringGenerator<Element>&
    IStringGenerator<Element> ::
      operator=( const IStringGenerator<Element>&
                    stringGenerator )
{
  fgeneratorFunction = stringGenerator.fgeneratorFunction;
  return *this;
}


template <class Element>
  IStringGenerator<Element> :: ~IStringGenerator ( )
{
}


template <class Element>
  IString IStringGenerator<Element> ::
    stringFor ( const Element& element ) const
{

  return fgeneratorFunction
            ? fgeneratorFunction->stringFor( element )
            : element->asString()     //This assumes an Element==Object*
            ;
}

