#ifndef _ISTRGEN_
  #define _ISTRGEN_
/*******************************************************************************
* FILE NAME: istrgen.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IStringGenerator                                                         *
*     IStringGeneratorFn                                                       *
*     IStringGeneratorMemberFn                                                 *
*     IStringGeneratorRefMemberFn                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <irefcnt.hpp>
#include <istring.hpp>

#pragma implementation("istrgen.c")
#pragma pack(4)


template < class T >
class IStringGeneratorFn : public IRefCounted {

typedef IRefCounted
  Inherited;

public:

  IStringGeneratorFn  ( ){}

virtual
 ~IStringGeneratorFn  ( ){}

/*------------------------- Generate String ----------------------------------*/
virtual IString
  stringFor           ( const T& object ) = 0;

private:
/*------------------------- Hidden Members -----------------------------------*/
  IStringGeneratorFn  ( const IStringGeneratorFn<T>& generatorFunction );

IStringGeneratorFn<T>
 &operator=           ( const IStringGeneratorFn<T>& generatorFunction );

}; // class IStringGeneratorFn<T>





template < class T >
class IStringGeneratorMemberFn : public IStringGeneratorFn<T> {

typedef IStringGeneratorFn<T>
  Inherited;

public:
/*------------------------- Constructors -------------------------------------*/
  IStringGeneratorMemberFn ( IString ( T::* member )( ) );

virtual
 ~IStringGeneratorMemberFn ( );

/*------------------------- Generate String ----------------------------------*/
virtual IString
  stringFor                ( const T& object );

private:
/*------------------------- Hidden Members -----------------------------------*/
  IStringGeneratorMemberFn ( const IStringGeneratorMemberFn<T>&
                                generatorMemberFunction );

IStringGeneratorMemberFn<T>
 &operator=                ( const IStringGeneratorMemberFn<T>&
                                generatorMemberFunction );

/*------------------------- Private ------------------------------------------*/

IString ( T::
 *memberFunction )( );

}; // IStringGeneratorMemberFn<T>





template < class T, class U>
class IStringGeneratorRefMemberFn : public IStringGeneratorFn<T> {

typedef IStringGeneratorFn<T>
  Inherited;

public:
/*------------------------- Constructors -------------------------------------*/
  IStringGeneratorRefMemberFn ( IString ( U :: *member )( ) );

virtual
 ~IStringGeneratorRefMemberFn ( );

/*------------------------- Generate String ----------------------------------*/
virtual IString
  stringFor                   ( const T& object );

private:
/*------------------------- Hidden Members -----------------------------------*/
  IStringGeneratorRefMemberFn ( const IStringGeneratorRefMemberFn<T,U>&
                                   generatorRefMemberFunction );

IStringGeneratorRefMemberFn<T,U>
 &operator=                   ( const IStringGeneratorRefMemberFn<T,U>&
                                   generatorRefMemberFunction );

/*------------------------- Private ------------------------------------------*/
IString ( U::
 *memberFunction )( );
}; // IStringGeneratorRefMemberFn<T,U>





template <class Element> class IStringGenerator : public IBase {

typedef IBase
  Inherited;

public:
/*------------------------- Constructors -------------------------------------*/
  IStringGenerator ( const IReference< IStringGeneratorFn<Element> >&
                                                      generatorFunction = 0 );

  IStringGenerator ( const IStringGenerator<Element>& stringGenerator );

IStringGenerator<Element>
 &operator=        ( const IStringGenerator<Element>& stringGenerator );

virtual
 ~IStringGenerator ( );

/*------------------------- Generate String ----------------------------------*/
IString
  stringFor        ( const Element& element ) const;

private:
/*------------------------- Private ------------------------------------------*/
IReference < IStringGeneratorFn<Element> >
  fgeneratorFunction;

}; // IStringGenerator<Element>

#if ! defined (__TEMPINC__)
#include <istrgen.c>
#endif


#pragma pack()

#endif  /* _ISTRGEN_ */
