#ifndef _ISTRING_INL_
#define _ISTRING_INL_ 0
/*******************************************************************************
* FILE NAME: istring.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Definition of the inline functions declared in istring.hpp.                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
extern "C"
  {
  #include <ctype.h>
  #include <limits.h>
  #include <string.h>
  #include <stdlib.h>
  }

#ifndef _ISTRING_
  #undef _ISTRING_INL_
  #define _ISTRING_INL_ 1
  #include <istring.hpp>
#endif

#include <iexcbase.hpp>
#include <ibuffer.hpp>
#include <istrtest.hpp>

#if _ISTRING_INL_
  #define inline
#endif

/*------------------------------ Implementation ------------------------------*/
inline IBuffer *IString :: buffer( ) const
  {
  #ifdef IC_DEVELOP
    IASSERT( pBuffer != 0 );
  #endif
  return IBuffer::fromContents( pBuffer );
  }


inline char *IString :: data ( ) const
  {
  return pBuffer;
  }
inline unsigned IString :: lengthOf ( const char *p )
  {
  return p ? strlen( p ) : 0;
  }
inline IString &IString :: setBuffer( IBuffer *ibuff )
  {
  #ifdef IC_DEVELOP
    IASSERT( ibuff != 0 );
  #endif
  pBuffer = ibuff->contents();
  return *this;
  }

/*-------------------------------- Accessors ---------------------------------*/
inline unsigned IString :: length ( ) const
  {
  return this->buffer() -> length();
  }
inline unsigned IString :: size ( ) const
  {
  return this->buffer() -> length();
  }
inline IStringEnum::CharType IString :: charType ( unsigned index ) const
  {
  return this->buffer() -> charType( index );
  }
/*-------------------------------- Searching ---------------------------------*/
inline unsigned IString :: indexOf ( const IString &aString,
                                     unsigned       startPos ) const
  {
  return this->buffer()->indexOf( aString.data(),
                                  aString.length(),
                                  startPos );
  }
inline unsigned IString :: indexOf ( const char *pString,
                                     unsigned    startPos ) const
  {
  return this->buffer()->indexOf( pString,
                                  lengthOf( pString ),
                                  startPos );
  }
inline unsigned IString :: indexOf ( const IStringTest &aTest,
                                     unsigned           startPos ) const
  {
  return this->buffer()->indexOf( aTest,
                                  startPos );
  }
inline unsigned IString :: indexOfAnyBut ( const IString &aString,
                                           unsigned       startPos ) const
  {
  return this->buffer()->indexOfAnyBut( aString.data(),
                                        aString.length(),
                                        startPos );
  }
inline unsigned IString :: indexOfAnyBut ( const char *pValidChars,
                                           unsigned    startPos ) const
  {
  return this->buffer()->indexOfAnyBut( pValidChars,
                                        lengthOf( pValidChars ),
                                        startPos );
  }
inline unsigned IString :: indexOfAnyBut ( char     validChar,
                                           unsigned startPos ) const
  {
  return this->buffer()->indexOfAnyBut( &validChar,
                                        1,
                                        startPos );
  }
inline unsigned IString :: indexOfAnyBut ( const IStringTest &aTest,
                                           unsigned           startPos ) const
  {
  return this->buffer()->indexOfAnyBut( aTest,
                                        startPos );
  }
inline unsigned IString :: indexOfAnyOf ( const IString &aString,
                                          unsigned       startPos ) const
  {
  return this->buffer()->indexOfAnyOf( aString.data(),
                                       aString.length(),
                                       startPos );
  }
inline unsigned IString :: indexOfAnyOf ( const char *pSearchChars,
                                          unsigned    startPos ) const
  {
  return this->buffer()->indexOfAnyOf( pSearchChars,
                                       lengthOf( pSearchChars ),
                                       startPos );
  }
inline unsigned IString :: indexOfAnyOf ( char     searchChar,
                                          unsigned startPos ) const
  {
  return this->buffer()->indexOfAnyOf( &searchChar,
                                       1,
                                       startPos );
  }
inline unsigned IString :: indexOfAnyOf ( const IStringTest &aTest,
                                          unsigned           startPos ) const
  {
  return this->buffer()->indexOfAnyOf( aTest,
                                       startPos );
  }
inline unsigned IString :: lastIndexOf ( const IString &aString,
                                         unsigned       startPos ) const
  {
  return this->buffer()->lastIndexOf( aString.data(),
                                      aString.length(),
                                      startPos );
  }
inline unsigned IString :: lastIndexOf ( const char *pString,
                                         unsigned    startPos ) const
  {
  return this->buffer()->lastIndexOf( pString,
                                      lengthOf( pString ),
                                      startPos );
  }
inline unsigned IString :: lastIndexOf ( const IStringTest &aTest,
                                         unsigned           startPos ) const
  {
  return this->buffer()->lastIndexOf( aTest,
                                      startPos );
  }
inline unsigned IString :: lastIndexOfAnyBut ( const IString &aString,
                                               unsigned       startPos ) const
  {
  return this->buffer()->lastIndexOfAnyBut( aString.data(),
                                            aString.length(),
                                            startPos );
  }
inline unsigned IString :: lastIndexOfAnyBut ( const char *pValidChars,
                                               unsigned    startPos ) const
  {
  return this->buffer()->lastIndexOfAnyBut( pValidChars,
                                            lengthOf( pValidChars ),
                                            startPos );
  }
inline unsigned IString :: lastIndexOfAnyBut ( char     validChar,
                                               unsigned startPos ) const
  {
  return this->buffer()->lastIndexOfAnyBut( &validChar,
                                            1,
                                            startPos );
  }
inline unsigned IString :: lastIndexOfAnyBut ( const IStringTest &aTest,
                                               unsigned       startPos ) const
  {
  return this->buffer()->lastIndexOfAnyBut( aTest,
                                           startPos );
  }
inline unsigned IString :: lastIndexOfAnyOf ( const IString &aString,
                                              unsigned       startPos ) const
  {
  return this->buffer()->lastIndexOfAnyOf( aString.data(),
                                           aString.length(),
                                           startPos );
  }
inline unsigned IString :: lastIndexOfAnyOf ( const char *pSearchChars,
                                              unsigned    startPos ) const
  {
  return this->buffer()->lastIndexOfAnyOf( pSearchChars,
                                           lengthOf( pSearchChars ),
                                           startPos );
  }
inline unsigned IString :: lastIndexOfAnyOf ( char     searchChar,
                                              unsigned startPos ) const
  {
  return this->buffer()->lastIndexOfAnyOf( &searchChar,
                                           1,
                                           startPos );
  }
inline unsigned IString :: lastIndexOfAnyOf ( const IStringTest &aTest,
                                              unsigned       startPos ) const
  {
  return this->buffer()->lastIndexOfAnyOf( aTest,
                                           startPos );
  }
inline unsigned IString :: occurrencesOf ( const IString &aString,
                                           unsigned       startPos ) const
  {
  return this->occurrencesOf( aString.data(),
                              aString.length(),
                              startPos );
  }
inline unsigned IString :: occurrencesOf ( const char *pString,
                                           unsigned    startPos ) const
  {
  return this->occurrencesOf( pString,
                              lengthOf( pString ),
                              startPos );
  }
/*--------------------------------- Testing ----------------------------------*/
inline IBase::Boolean IString :: isAlphanumeric ( ) const
  { return this->buffer()->isAlphanumeric(); }
inline IBase::Boolean IString :: isAlphabetic ( ) const
  { return this->buffer()->isAlphabetic(); }
inline IBase::Boolean IString :: isASCII ( ) const
  { return this->buffer()->isASCII(); }
inline IBase::Boolean IString :: isControl ( ) const
  { return this->buffer()->isControl(); }
inline IBase::Boolean IString :: isDigits ( ) const
  { return this->buffer()->isDigits(); }
inline IBase::Boolean IString :: isGraphics ( ) const
  { return this->buffer()->isGraphics(); }
inline IBase::Boolean IString :: isHexDigits ( ) const
  { return this->buffer()->isHexDigits(); }
inline IBase::Boolean IString :: isLowerCase ( ) const
  { return this->buffer()->isLowerCase(); }
inline IBase::Boolean IString :: isPrintable ( ) const
  { return this->buffer()->isPrintable(); }
inline IBase::Boolean IString :: isPunctuation ( ) const
  { return this->buffer()->isPunctuation(); }
inline IBase::Boolean IString :: isUpperCase ( ) const
  { return this->buffer()->isUpperCase(); }
inline IBase::Boolean IString :: isWhiteSpace ( ) const
  { return this->buffer()->isWhiteSpace(); }
inline IBase::Boolean IString :: isMBCS ( ) const
  { return this->buffer()->isMBCS(); }
inline IBase::Boolean IString :: isDBCS ( ) const
  { return this->buffer()->isDBCS(); }
inline IBase::Boolean IString :: isSBCS ( ) const
  { return this->buffer()->isSBCS(); }
inline IBase::Boolean IString :: isValidMBCS ( ) const
  { return this->buffer()->isValidMBCS(); }
inline IBase::Boolean IString :: isValidDBCS ( ) const
  { return this->buffer()->isValidDBCS(); }
inline IBase::Boolean IString :: includesMBCS ( ) const
  { return this->buffer()->includesMBCS(); }
inline IBase::Boolean IString :: includesDBCS ( ) const
  { return this->buffer()->includesDBCS(); }
inline IBase::Boolean IString :: includesSBCS ( ) const
  { return this->buffer()->includesSBCS(); }
inline IBase::Boolean IString :: isLike ( const IString &aPattern,
                                          char           zeroOrMore,
                                          char           anyChar ) const
  {
  return this->isLike( aPattern.data(),
                       aPattern.length(),
                       zeroOrMore,
                       anyChar );
  }
inline IBase::Boolean IString :: isLike ( const char *pPattern,
                                          char        zeroOrMore,
                                          char        anyChar ) const
  {
  return this->isLike( pPattern,
                       lengthOf(pPattern),
                       zeroOrMore,
                       anyChar );
  }
inline IBase::Boolean IString :: isAbbreviationFor (
                                        const IString &aString,
                                        unsigned       minAbbrevLength ) const
  {
  return this->isAbbrevFor( aString.data(),
                            aString.length(),
                            minAbbrevLength );
  }
inline IBase::Boolean IString :: isAbbreviationFor (
                                        const char *pString,
                                        unsigned    minAbbrevLength ) const
  {
  return this->isAbbrevFor( pString,
                            lengthOf( pString ),
                            minAbbrevLength );
  }
inline IBase::Boolean IString :: includes ( const IString &aString ) const
  {
  return this->indexOf( aString );
  }
inline IBase::Boolean IString :: includes ( const char *pString ) const
  {
  return this->indexOf( pString );
  }
inline IBase::Boolean IString :: includes ( char aChar ) const
  {
  return this->indexOf( aChar );
  }
inline IBase::Boolean IString :: includes ( const IStringTest &aTest ) const
  {
  return this->indexOf( aTest );
  }
/*--------------------------- Comparison Operators ---------------------------*/
inline IBase::Boolean operator == ( const IString &string1,
                                    const IString &string2 )
  {
  return ( string1.buffer()->compare( string2.data(),
                                     string2.length() ) == IBuffer::equal );
  }
inline IBase::Boolean operator == ( const IString &string1,
                                    const char    *pString2 )
  {
  return
    ( string1.buffer()->compare( pString2,
                                 IString::lengthOf( pString2 ) )
      == IBuffer::equal );
  }
inline IBase::Boolean operator == ( const char    *pString1,
                                    const IString &string2 )
  {
  return
    ( string2.buffer()->compare( pString1,
                                 IString::lengthOf( pString1 ) )
      == IBuffer::equal );
  }
inline IBase::Boolean operator != ( const IString &string1,
                                    const IString &string2 )
  {
  return !( string1 == string2 );
  }
inline IBase::Boolean operator != ( const IString &string1,
                                    const char    *pString2 )
  {
  return !( string1 == pString2 );
  }
inline IBase::Boolean operator != ( const char    *pString1,
                                    const IString &string2 )
  {
  return !( pString1 == string2 );
  }
inline IBase::Boolean operator >  ( const IString &string1,
                                    const IString &string2 )
  {
  return
    ( string1.buffer()->compare( string2.data(),
                                 string2.length() )
      == IBuffer::greaterThan );
  }
inline IBase::Boolean operator >  ( const IString &string1,
                                    const char    *pString2 )
  {
  return
    ( string1.buffer()->compare( pString2,
                                 IString::lengthOf( pString2 ) )
      == IBuffer::greaterThan );
  }
inline IBase::Boolean operator >  ( const char    *pString1,
                                    const IString &string2 )
  {
  return
    ( string2.buffer()->compare( pString1,
                                 IString::lengthOf( pString1 ) )
      == IBuffer::lessThan );
  }
inline IBase::Boolean operator >= ( const IString &string1,
                                    const IString &string2 )
  {
  return !
    ( string1.buffer()->compare( string2.data(),
                                 string2.length() )
      == IBuffer::lessThan );
  }
inline IBase::Boolean operator >= ( const IString &string1,
                                    const char    *pString2 )
  {
  return !
    ( string1.buffer()->compare( pString2,
                                 IString::lengthOf( pString2 ) )
      == IBuffer::lessThan );
  }
inline IBase::Boolean operator >= ( const char    *pString1,
                                    const IString &string2 )
  {
  return !
    ( string2.buffer()->compare( pString1,
                                 IString::lengthOf( pString1 ) )
      == IBuffer::greaterThan );
  }
inline IBase::Boolean operator <  ( const IString &string1,
                                    const IString &string2 )
  {
  return !( string1 >= string2 );
  }
inline IBase::Boolean operator <  ( const IString &string1,
                                    const char    *pString2)
  {
  return !( string1 >= pString2 );
  }
inline IBase::Boolean operator <  ( const char    *pString1,
                                    const IString &string2)
  {
  return !( pString1 >= string2 );
  }
inline IBase::Boolean operator <= ( const IString &string1,
                                    const IString &string2 )
  {
  return !( string1 > string2 );
  }
inline IBase::Boolean operator <= ( const IString &string1,
                                    const char    *pString2 )
  {
  return !( string1 > pString2 );
  }
inline IBase::Boolean operator <= ( const char    *pString1,
                                    const IString &string2 )
  {
  return !( pString1 > string2 );
  }
/*-------------------------------- Conversion --------------------------------*/
inline IString IString :: asString ( ) const
  {
  return *this;
  }
inline long int IString :: asInt ( ) const
  {
  return strtol( this->data(), 0, 10 );
  }
inline unsigned long IString :: asUnsigned ( ) const
  {
  return strtoul( this->data(), 0, 10 );
  }
#ifdef _LONG_LONG
inline long long int IString :: asLongLong ( ) const
  {
  return strtoll( this->data(), 0, 10 );
  }
inline unsigned long long IString :: asUnsignedLongLong ( ) const
  {
  return strtoull( this->data(), 0, 10 );
  }
#endif
inline double IString :: asDouble ( ) const
  {
  return strtod( this->data(), 0 );
  }
inline IString :: operator char* ( ) const
  {
  return this->data();
  }
inline IString :: operator unsigned char* ( ) const
  {
  return (unsigned char*) this->data();
  }
inline IString :: operator signed char* ( ) const
  {
  return (signed char*) this->data();
  }
inline IString IString :: c2b( const IString &aString )
  {
  return IString(aString).c2b();
  }
inline IString IString :: c2d( const IString &aString )
  {
  return IString(aString).c2d();
  }
inline IString IString :: c2x( const IString &aString )
  {
  return IString(aString).c2x();
  }
inline IString IString :: b2c( const IString &aString )
  {
  return IString(aString).b2c();
  }
inline IString & IString :: b2d ( )
  {
  this->b2c().c2d();
  return *this;
  }
inline IString IString :: b2d( const IString &aString )
  {
  return IString(aString).b2d();
  }
inline IString & IString :: b2x ( )
  {
  this->b2c().c2x();
  return *this;
  }
inline IString IString :: b2x( const IString &aString )
  {
  return IString(aString).b2x();
  }
inline IString IString :: d2c( const IString &aString )
  {
  return IString(aString).d2c();
  }
inline IString & IString :: d2b ( )
  {
  this->d2c().c2b();
  return *this;
  }
inline IString IString :: d2b( const IString &aString )
  {
  return IString(aString).d2b();
  }
inline IString & IString :: d2x ( )
  {
  this->d2c().c2x();
  return *this;
  }
inline IString IString :: d2x( const IString &aString )
  {
  return IString(aString).d2x();
  }
inline IString IString :: x2c( const IString &aString )
  {
  return IString(aString).x2c();
  }
inline IString & IString :: x2b ( )
  {
  this->x2c().c2b();
  return *this;
  }
inline IString IString :: x2b( const IString &aString )
  {
  return IString(aString).x2b();
  }
inline IString & IString :: x2d ( )
  {
  this->x2c().c2d();
  return *this;
  }
inline IString IString :: x2d( const IString &aString )
  {
  return IString(aString).x2d();
  }
/*--------------------------------- Editing ----------------------------------*/
inline IString & IString :: change ( const IString &aPattern,
                                     const IString &aReplacement,
                                     unsigned       startPos,
                                     unsigned       numChanges )
  {
  return this->change( aPattern.data(),
                       aPattern.length(),
                       aReplacement.data(),
                       aReplacement.length(),
                       startPos,
                       numChanges );
  }
inline IString & IString :: change ( const IString &aPattern,
                                     const char    *pReplacement,
                                     unsigned       startPos,
                                     unsigned       numChanges )
  {
  return this->change( aPattern.data(),
                       aPattern.length(),
                       pReplacement,
                       lengthOf( pReplacement ),
                       startPos,
                       numChanges );
  }
inline IString & IString :: change ( const char    *pPattern,
                                     const IString &aReplacement,
                                     unsigned       startPos,
                                     unsigned       numChanges )
  {
  return this->change( pPattern,
                       lengthOf( pPattern ),
                       aReplacement.data(),
                       aReplacement.length(),
                       startPos,
                       numChanges );
  }
inline IString & IString :: change ( const char *pPattern,
                                     const char *pReplacement,
                                     unsigned    startPos,
                                     unsigned    numChanges )
  {
  return this->change( pPattern,
                       lengthOf( pPattern ),
                       pReplacement,
                       lengthOf( pReplacement ),
                       startPos,
                       numChanges );
  }
inline IString IString :: change ( const IString &aString,
                        const IString &aPattern,
                        const char    *pReplacement,
                        unsigned       startPos,
                        unsigned       numChanges )
  {
  return IString(aString).change( aPattern,
                                  pReplacement,
                                  startPos,
                                  numChanges );
  }
inline IString IString :: change ( const IString &aString,
                        const char    *pPattern,
                        const IString &aReplacement,
                        unsigned       startPos,
                        unsigned       numChanges )
  {
  return IString(aString).change( pPattern,
                                  aReplacement,
                                  startPos,
                                  numChanges );
  }
inline IString IString :: copy ( const IString &aString,
                      unsigned       numCopies )
  {
  return IString(aString).copy( numCopies );
  }
inline IString & IString :: insert ( const IString &aString,
                                     unsigned       index,
                                     char           padCharacter )
  {
  return this->insert( aString.data(),
                       aString.length(),
                       index,
                       padCharacter );
  }
inline IString & IString :: insert ( const char *pString,
                                     unsigned    index,
                                     char        padCharacter )
  {
  return this->insert( pString,
                       lengthOf( pString ),
                       index,
                       padCharacter );
  }
inline IString IString :: insert ( const IString &aString,
                        const IString &anInsert,
                        unsigned       index,
                        char           padCharacter )
  {
  return IString(aString).insert( anInsert, index, padCharacter );
  }
inline IString IString :: insert ( const IString &aString,
                        const char    *pInsert,
                        unsigned       index,
                        char           padCharacter )
  {
  return IString(aString).insert( pInsert, index, padCharacter );
  }
inline IString IString :: leftJustify ( const IString &aString,
                             unsigned       newLength,
                             char           padCharacter )
  {
  return IString(aString).leftJustify( newLength, padCharacter );
  }
inline IString IString :: lowerCase ( const IString &aString )
  {
  return IString(aString).lowerCase();
  }
inline IString & IString :: overlayWith ( const IString &aString,
                                          unsigned       index,
                                          char           padCharacter )
  {
  return this->overlayWith( aString.data(),
                            aString.length(),
                            index,
                            padCharacter );
  }
inline IString& IString :: overlayWith ( const char *pString,
                                         unsigned    index,
                                         char        padCharacter )
   {
   return this->overlayWith( pString,
                             lengthOf( pString ),
                             index,
                             padCharacter );
   }
inline IString IString :: overlayWith ( const IString &aString,
                             const IString &anOverlay,
                             unsigned       index,
                             char           padCharacter )
  {
  return IString(aString).overlayWith( anOverlay, index, padCharacter );
  }
inline IString IString :: overlayWith ( const IString &aString,
                             const char    *pOverlay,
                             unsigned       index,
                             char           padCharacter )
  {
  return IString(aString).overlayWith( pOverlay, index, padCharacter );
  }
inline IString IString :: remove ( const IString &aString,
                                   unsigned       startPos )
  {
  return IString::remove( aString, startPos, (unsigned)UINT_MAX );
  }
inline IString IString :: reverse ( const IString &aString )
  {
  return IString(aString).reverse();
  }
inline IString IString :: rightJustify ( const IString &aString,
                              unsigned       newLength,
                              char           padCharacter )
  {
  return IString(aString).rightJustify( newLength, padCharacter );
  }
inline IString & IString :: stripLeading ( )
  {
  return this->strip( IStringTest( isspace ), IStringEnum::leading );
  }
inline IString & IString :: stripTrailing ( )
  {
  return this->strip( IStringTest( isspace ), IStringEnum::trailing );
  }
inline IString & IString :: strip ( char aChar )
  {
  return this->strip( &aChar, 1, IStringEnum::both );
  }
inline IString & IString :: stripLeading ( char aChar )
  {
  return this->strip( &aChar, 1, IStringEnum::leading );
  }
inline IString & IString :: stripTrailing ( char aChar )
  {
  return this->strip( &aChar, 1, IStringEnum::trailing );
  }
inline IString & IString :: strip ( const IString &aString )
  {
  return this->strip( aString.data(), aString.length(), IStringEnum::both );
  }
inline IString & IString :: stripLeading ( const IString &aString )
  {
  return this->strip( aString.data(), aString.length(), IStringEnum::leading );
  }
inline IString & IString :: stripTrailing ( const IString &aString )
  {
  return this->strip( aString.data(), aString.length(), IStringEnum::trailing );
  }
inline IString & IString :: strip ( const char *pString )
  {
  return this->strip( pString, lengthOf( pString ), IStringEnum::both );
  }
inline IString & IString :: stripLeading ( const char *pString )
  {
  return this->strip( pString, lengthOf( pString ), IStringEnum::leading );
  }
inline IString & IString :: stripTrailing ( const char *pString )
  {
  return this->strip( pString, lengthOf( pString ), IStringEnum::trailing );
  }
inline IString & IString :: strip ( const IStringTest &aTest )
  {
  return this->strip( aTest, IStringEnum::both );
  }
inline IString & IString :: stripLeading ( const IStringTest &aTest )
  {
  return this->strip( aTest, IStringEnum::leading );
  }
inline IString & IString :: stripTrailing ( const IStringTest &aTest )
  {
  return this->strip( aTest, IStringEnum::trailing );
  }
inline IString IString :: stripBlanks ( const IString &aString )
  {
  return IString(aString).strip();
  }
inline IString IString :: strip ( const IString &aString,
                       char           aChar )
  {
  return IString(aString).strip(aChar);
  }
inline IString IString :: strip ( const IString &aString,
                       const IString &aStringOfChars )
  {
  return IString(aString).strip(aStringOfChars);
  }
inline IString IString :: strip ( const IString &aString,
                       const char    *pStringOfChars )
  {
  return IString(aString).strip(pStringOfChars);
  }
inline IString IString :: strip ( const IString     &aString,
                       const IStringTest &aTest )
  {
  return IString(aString).strip(aTest);
  }
inline IString IString :: stripLeadingBlanks ( const IString &aString )
  {
  return IString(aString).stripLeading();
  }
inline IString IString :: stripLeading ( const IString &aString,
                              char           aChar )
  {
  return IString(aString).stripLeading(aChar);
  }
inline IString IString :: stripLeading ( const IString &aString,
                              const IString &aStringOfChars )
  {
  return IString(aString).stripLeading(aStringOfChars);
  }
inline IString IString :: stripLeading ( const IString &aString,
                              const char    *pStringOfChars )
  {
  return IString(aString).stripLeading(pStringOfChars);
  }
inline IString IString :: stripLeading ( const IString     &aString,
                              const IStringTest &aTest )
  {
  return IString(aString).stripLeading(aTest);
  }
inline IString IString :: stripTrailingBlanks ( const IString &aString )
  {
  return IString(aString).stripTrailing();
  }
inline IString IString :: stripTrailing ( const IString &aString,
                               char           aChar )
  {
  return IString(aString).stripTrailing(aChar);
  }
inline IString IString :: stripTrailing ( const IString &aString,
                               const IString &aStringOfChars )
  {
  return IString(aString).stripTrailing(aStringOfChars);
  }
inline IString IString :: stripTrailing ( const IString &aString,
                               const char    *pStringOfChars )
  {
  return IString(aString).stripTrailing(pStringOfChars);
  }
inline IString IString :: stripTrailing ( const IString     &aString,
                               const IStringTest &aTest )
  {
  return IString(aString).stripTrailing(aTest);
  }
inline IString & IString :: translate ( const IString &inputChars,
                                        const IString &outputChars,
                                        char           padCharacter )
  {
  return this->translate( inputChars.data(),
                          inputChars.length(),
                          outputChars.data(),
                          outputChars.length(),
                          padCharacter );
  }
inline IString & IString :: translate ( const IString &inputChars,
                                        const char    *pOutputChars,
                                        char           padCharacter )
  {
  return this->translate( inputChars.data(),
                          inputChars.length(),
                          pOutputChars,
                          lengthOf( pOutputChars ),
                          padCharacter );
  }
inline IString & IString :: translate ( const char    *pInputChars,
                                        const IString &outputChars,
                                        char           padCharacter )
  {
  return this->translate( pInputChars,
                          lengthOf( pInputChars ),
                          outputChars.data(),
                          outputChars.length(),
                          padCharacter );
  }
inline IString & IString :: translate ( const char *pInputChars,
                                        const char *pOutputChars,
                                        char        padCharacter )
  {
  return this->translate( pInputChars,
                          lengthOf( pInputChars ),
                          pOutputChars,
                          lengthOf( pOutputChars ),
                          padCharacter );
  }
inline IString IString :: translate ( const IString &aString,
                           const IString &inputChars,
                           const IString &outputChars,
                           char           padCharacter )
  {
  return IString(aString).translate( inputChars, outputChars, padCharacter );
  }
inline IString IString :: translate ( const IString &aString,
                           const IString &inputChars,
                           const char    *pOutputChars,
                           char           padCharacter )
  {
  return IString(aString).translate( inputChars, pOutputChars, padCharacter );
  }
inline IString IString :: translate ( const IString &aString,
                           const char    *pInputChars,
                           const IString &outputChars,
                           char           padCharacter )
  {
  return IString(aString).translate( pInputChars, outputChars, padCharacter );
  }
inline IString IString :: translate ( const IString &aString,
                           const char    *pInputChars,
                           const char    *pOutputChars,
                           char           padCharacter )
  {
  return IString(aString).translate( pInputChars, pOutputChars, padCharacter );
  }
/*------------------------------ Word Functions ------------------------------*/
inline IString & IString :: removeWords ( unsigned firstWord )
  {
  return this->removeWords( firstWord, (unsigned)UINT_MAX );
  }
inline IString IString :: removeWords ( const IString &aString,
                             unsigned       firstWord )
  {
  return IString(aString).removeWords( firstWord );
  }
inline IString IString :: removeWords ( const IString &aString,
                             unsigned       firstWord,
                             unsigned       numWords )
  {
  return IString(aString).removeWords( firstWord, numWords );
  }
inline unsigned IString :: indexOfPhrase ( const IString &aPhrase,
                                           unsigned       startWord ) const
   {
   return this->findPhrase ( aPhrase, startWord, charIndex );
   }
inline unsigned IString :: indexOfWord ( unsigned wordNumber ) const
  {
  return this->indexOfWord( wordNumber, 1, 0 );
  }
inline unsigned IString :: wordIndexOfPhrase( const IString &aPhrase,
                                              unsigned       startWord ) const
  {
  return this->findPhrase( aPhrase, startWord, wordIndex );
  }
inline IString IString :: space ( const IString &aString,
                       unsigned       numSpaces,
                       char           spaceChar )
  {
  return IString(aString).space( numSpaces, spaceChar );
  }
inline IString IString :: words ( unsigned firstWord ) const
  {
  return this->words( firstWord, (unsigned)UINT_MAX );
  }

inline char &IString :: operator [] ( unsigned long index )
  {
  return this->operator[]( (unsigned) index );
  }
inline const char &IString :: operator [] ( unsigned long index ) const
  {
  return this->operator[]( (unsigned) index );
  }
inline char &IString :: operator [] ( signed long index )
  {
  return this->operator[]( (signed) index );
  }
inline const char &IString :: operator [] ( signed long index ) const
  {
  return this->operator[]( (signed) index );
  }



#endif /* _ISTRING_INL_ */
