#ifndef _ISWP_
#define _ISWP_
/*******************************************************************************
* FILE NAME: iswp.hpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISWP                                                                     *
*     ISWPArray                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ihandle.hpp>

class IPoint;
class ISize;

#pragma pack(4)

class ISWP : public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ISWP      ( );
  ISWP      ( const ISWP& original );

 ~ISWP      ( );

ISWP
 &operator= ( const ISWP& original );

/*--------------------------- Window Manipulation ----------------------------*/
IWindowHandle
  windowHandle ( ) const;

IPoint
  position     ( ) const;
ISize
  size         ( ) const;

ISWP
 &setPosition  ( const IPoint& point ),
 &setSize      ( const ISize&  size );

ISWP
 &setMove      ( Boolean enable = true ),
 &setSizeFlag  ( Boolean enable = true ),
 &setShow      ( Boolean enable = true ),
 &setHide      ( Boolean enable = true ),
 &setZOrder    ( Boolean enable = true ),
 &setNoAdjust  ( Boolean enable = true );

unsigned long
 &flags        ( );

/*--------------------------------- Testing ----------------------------------*/
Boolean
  isMove   ( ) const,
  isSize   ( ) const,
  isShow   ( ) const,
  isHide   ( ) const,
  isZOrder ( ) const;

/*----------------------------------- Data -----------------------------------*/

IWindowHandle
  hwnd,
  behind;
long
  x,
  y,
  cx,
  cy;
unsigned long
  fl;
};  // ISWP

class ISWPArray : public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ISWPArray ( ISWP*    array,
              unsigned dimension );

/*------------------------------ Array Contents ------------------------------*/
unsigned
  size        ( ) const;

ISWP
 &operator [] ( unsigned index );

unsigned
  indexOf     ( unsigned long windowId ) const;

private:
/*--------------------------------- Private ----------------------------------*/
ISWP
 *p;
unsigned
  dim;
}; // ISWPArray

#pragma pack()

  #include <iswp.inl>

#endif // _ISWP_
