#ifndef _ISWP_INL_
#define _ISWP_INL_ 0
/*******************************************************************************
* FILE NAME: iswp.inl                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in iswp.hpp.                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _ISWP_
  #undef  _ISWP_INL_
  #define _ISWP_INL_ 1
  #include <iswp.hpp>
#endif

#include <ipoint.hpp>

#if _ISWP_INL_
  #define inline
#endif

/*------------------------------------------------------------------------------
| ISWP::ISWP                                                                   |
------------------------------------------------------------------------------*/
inline ISWP::ISWP ( )
  : fl          ( 0 ),
    cy          ( 0 ),
    cx          ( 0 ),
    y           ( 0 ),
    x           ( 0 ),
    behind      ( 0 ),
    hwnd        ( 0 )
{ }

/*------------------------------------------------------------------------------
| ISWP::ISWP                                                                   |
------------------------------------------------------------------------------*/
inline ISWP::ISWP ( const ISWP& original )
  : fl          ( original.fl     ),
    cy          ( original.cy     ),
    cx          ( original.cx     ),
    y           ( original.y      ),
    x           ( original.x      ),
    behind      ( original.behind ),
    hwnd        ( original.hwnd   )
{ }

/*------------------------------------------------------------------------------
| ISWP::~ISWP                                                                  |
------------------------------------------------------------------------------*/
inline ISWP::~ISWP ( )
{ }

/*------------------------------------------------------------------------------
| ISWP::operator=                                                              |
------------------------------------------------------------------------------*/
inline ISWP& ISWP::operator= ( const ISWP& original )
{
   if (this != &original)
      {
      fl          = original.fl     ;
      cy          = original.cy     ;
      cx          = original.cx     ;
      y           = original.y      ;
      x           = original.x      ;
      behind      = original.behind ;
      hwnd        = original.hwnd   ;
      }
   return *this;
}

inline IWindowHandle ISWP::windowHandle ( ) const
  {
  return this->hwnd;
  }

inline IPoint ISWP::position ( ) const
  {
  return IPoint( this->x, this->y );
  }

inline ISWP& ISWP::setPosition ( const IPoint& point )
  {
  this->x = point.x();
  this->y = point.y();
  return *this;
  }

inline ISize ISWP::size ( ) const
  {
  return ISize( this->cx, this->cy );
  }

inline ISWP& ISWP::setSize ( const ISize& size )
  {
  this->cx = size.width();
  this->cy = size.height();
  return *this;
  }

inline ISWPArray::ISWPArray ( ISWP* array, unsigned dimension )
  : p( array ),
    dim( dimension )
  {
  }

inline unsigned long& ISWP::flags ( )
  {
  return this->fl;
  }

inline unsigned ISWPArray::size ( ) const
  {
  return this->dim;
  }

inline ISWP& ISWPArray::operator [] ( unsigned index )
  {
  return p[index];
  }

#endif // _ISWP_INL_
