#ifndef _ITBARCNR_
#define _ITBARCNR_
/*******************************************************************************
* FILE NAME: itbarcnr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IToolBarContainer                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <isetcv.hpp>
#include <iframe.hpp>

class IToolBar;
class IToolBarContainerData;

#pragma pack(4)


class IToolBarContainer : public ISetCanvas
{
typedef ISetCanvas
  Inherited;
public:
class Style;
/*------------------------------ Constructors --------------------------------*/
  IToolBarContainer ( unsigned long          identifier,
                      IFrameWindow*          parentAndOwner,
                      IFrameWindow::Location location,
                      const Style&           style = defaultStyle() );

virtual
  ~IToolBarContainer ();

/*------------------------------ Styles --------------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, IToolBarContainer, ISetCanvas, ICanvas, IWindow);

static const Style
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*---------------------------- Frame Location --------------------------------*/
virtual IToolBarContainer
 &setLocation            ( IFrameWindow::Location location );

IFrameWindow::Location
  location               ( ) const;

static IToolBarContainer
  *frameToolBarContainer ( IFrameWindow*          frame,
                           IFrameWindow::Location frameLocation );

/*----------------------------- Canvas Layout --------------------------------*/
virtual IToolBarContainer
 &setLayoutDistorted ( unsigned long layoutAttributeOn,
                       unsigned long layoutAttributeOff );

/*-------------------------------- Private -----------------------------------*/
private:

friend class IToolBar;

IToolBarContainer            (const IToolBarContainer&);
IToolBarContainer& operator= (const IToolBarContainer&);

static Style
  fgCurrentDefaultStyle;

IToolBarContainerData
 *fToolBarContainerData;
};

// global style functions
INESTEDBITFLAGCLASSFUNCS(Style, IToolBarContainer);


#pragma pack()

#endif /* _ITBARCNR_ */
