#ifndef _ITHREAD_
#define _ITHREAD_
/*******************************************************************************
* FILE NAME: ithread.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IThread                                                                  *
*     IThread::Cursor                                                          *
*     IThreadFn                                                                *
*     IThreadMemberFn                                                          *
*     ICurrentThread                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <iapp.hpp>
#include <ihandle.hpp>
#include <irefcnt.hpp>

struct tib_s;
class ICurrentThread;
class ICurrentThreadData;
class IDialogControls;
class IRelatedHandlesList;
class IStartedThread;
class IThreadCursorData;
class IThreadData;
class IWindowList;

#pragma pack(4)

class IThreadFn : public IRefCounted {
typedef IRefCounted
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IThreadFn ( );
virtual
 ~IThreadFn ( );

/*------------------------------- Run Function -------------------------------*/
virtual void
  run ( ) = 0;

private:
/*------------------------------ Hidden Members ------------------------------*/
  IThreadFn ( const IThreadFn& function );
IThreadFn
 &operator= ( const IThreadFn& function );
}; // class IThreadFn


template < class T >
class IThreadMemberFn : public IThreadFn {
typedef IThreadFn
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
IThreadMemberFn ( T &obj,
                  void ( T :: *mem )( ) );          // 7810
virtual
 ~IThreadMemberFn ( );                              // 7810

/*------------------------------- Run Function -------------------------------*/
virtual void
  run ( )
  {
    (object.*member)();
  }

private:
/*------------------------------ Hidden Members ------------------------------*/
  IThreadMemberFn ( const IThreadMemberFn<T>& threadFunction );
IThreadMemberFn<T>
 &operator=       ( const IThreadMemberFn<T>& threadFunction );

/*--------------------------------- Private ----------------------------------*/
T
 &object;
void ( T ::
 *member )( );
}; // IThreadMemberFn

template < class T >
IThreadMemberFn<T>::IThreadMemberFn ( T &obj,
                  void ( T :: *mem )( ) )         // 7810
  : member( mem ), object( obj )
{ 
}

template < class T >
IThreadMemberFn<T>::~IThreadMemberFn ( )          // 7810
{ 
}

class IThread : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------ Function Types ------------------------------*/
typedef void ( _Optlink* OptlinkFnPtr ) ( void* );
typedef void ( _System*  SystemFnPtr  ) ( unsigned long );

/*------------------------------- Constructors -------------------------------*/
  IThread ( );
  IThread ( const IThread&       thread );
  IThread ( const IThreadId&     threadID,
            const IThreadHandle& threadHandle = IThreadHandle::noHandle );

  IThread ( const IReference<IThreadFn>& threadFunction,
            Boolean              autoInitGUI = defaultAutoInitGUI() );
  IThread ( OptlinkFnPtr         function,
            void*                functionArgument,
            Boolean              autoInitGUI = defaultAutoInitGUI() );
  IThread ( SystemFnPtr          function,
            unsigned long        functionArgument,
            Boolean              autoInitGUI = defaultAutoInitGUI() );

virtual
 ~IThread ( );

/*---------------------- Starting and Stopping Threads -----------------------*/
void
  start   ( const IReference<IThreadFn>& threadFunction,
            Boolean        autoInitGUI = defaultAutoInitGUI() ),
  start   ( OptlinkFnPtr   function,
            void*          functionArgument,
            Boolean        autoInitGUI = defaultAutoInitGUI() ),
  start   ( SystemFnPtr    function,
            unsigned long  functionArgument,
            Boolean        autoInitGUI = defaultAutoInitGUI() );

virtual void
  stop    ( );

virtual void
  suspend ( ),
  resume  ( );

/*----------------------------- Thread Information ---------------------------*/
static ICurrentThread
 &current     ( );

virtual IThreadId
  id          ( ) const;

static IThreadId
  currentId   ( );

virtual IThreadHandle
  handle      ( ) const;

static IThreadHandle
  currentHandle ( );

IString
  variable    ( const IString& key ) const;

IThread
 &setVariable ( const IString& key,
                const IString& value );

virtual Boolean
  isStarted   ( ) const;

/*-------------------------------- Diagnostics -------------------------------*/
virtual IString
  asString    ( ) const,
  asDebugInfo ( ) const;

/*-------------------- Graphical User Interface (GUI) Support ----------------*/
virtual Boolean
  autoInitGUI           ( ) const;

virtual IThread
 &setAutoInitGUI        ( Boolean initFlag = true );

static Boolean
  defaultAutoInitGUI    ( );

static void
  setDefaultAutoInitGUI ( Boolean initFlag = true );

virtual IThread
 &stopProcessingMsgs    ( );

/*-------------------------------- Stack Size --------------------------------*/
virtual unsigned long
  stackSize           ( ) const;

virtual IThread
 &setStackSize        ( unsigned long size );

static unsigned long
  defaultStackSize    ( );

static void
  setDefaultStackSize ( unsigned long size );

/*---------------------------- Message Queue ---------------------------------*/
#ifndef IC_MOTIFWIN_FLAGNOP
virtual long
  queueSize           ( ) const;

virtual IThread
 &setQueueSize        ( long queueSize );

static long
  defaultQueueSize    ( );

static void
  setDefaultQueueSize ( long queueSize );
#endif // not IC_MOTIFWIN_FLAGNOP

IMessageQueueHandle
  messageQueue        ( ),
  messageQueue        ( ) const;

/*----------------------------- Thread Priority ------------------------------*/
virtual unsigned
  priorityLevel  ( ) const;

virtual IApplication::PriorityClass
  priorityClass  ( ) const;

virtual IThread
 &setPriority    ( IApplication::PriorityClass priority,
                   unsigned                    level ),
 &adjustPriority ( int delta );


/*------------------------------ Implementation ------------------------------*/
IWindowList
 *windowList    ( ) const;

IThread
 &setWindowList ( IWindowList* list );


IDialogControls
  *dialogControls ( ) const;

class Cursor : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  Cursor ( Boolean allThreads = true );
virtual
 ~Cursor ( );

/*----------------------------- Thread Iteration -----------------------------*/
Boolean
  setToFirst ( ),
  setToNext  ( ),
  isValid    ( ) const;

virtual void
  invalidate ( );

IThreadId
  threadId   ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
friend class IStartedThread;
friend class IWindow;

Boolean
  all,
  iteratedAll,
  advance ( );

unsigned
  cursor,
  created;

static unsigned
  timeStamp;

IThreadCursorData
 *fCursorData;
}; // IThread::Cursor

protected:
/*------------------------------ Implementation ------------------------------*/
virtual IStartedThread
 *startedThread    ( ) const;

static IStartedThread
 *newStartedThread ( );

/*------------------------------- Constructors -------------------------------*/
IThread
 &operator = ( const IThread& thread );

private:
/*--------------------------------- Private ----------------------------------*/
friend class ICurrentThread;
friend class IWindow;

IStartedThread
 *prepareToStart ( const IReference<IThreadFn>& threadFunction,
                   Boolean         autoInitGUI );

void
  threadStarted  ( IStartedThread* thread,
                   int             rc );

static Boolean
  inGUISession   ( );

Boolean
  inMsgLoop      ( ) const;

IStartedThread
 *thread;

static unsigned long
  dfltStackSize;

static Boolean
  dfltAutoInitGUI;


static long
  dfltQueueSize;

static ICurrentThread
 *pCurrent;

IThreadData
 *fThreadData;

//------------------------------------------------------------
// DEFECT 8421/7546 : correct thread prioritie handling on NT
//------------------------------------------------------------
private:
   int relativePriorityLevel( IStartedThread* p, int requestedLevel ) const;
   int actualPriorityLevel( IStartedThread* pThread ) const;
   int basePriorityLevel( IStartedThread* pThread ) const;
//------------------------------------------------------------
}; // IThread


class ICurrentThread : public IThread {
typedef IThread
  Inherited;
public:
/*------------------ Graphical User Interface (GUI) Support ------------------*/
virtual void
  initializeGUI    ( long queueSize = 30 ),
#ifndef IC_WIN_FLAGNOP
  terminateGUI     ( ),
#endif
  processMsgs      ( );

virtual Boolean
  isGUIInitialized ( ) const;

#ifndef IC_MOTIFWIN_FLAGNOP
virtual IAnchorBlockHandle
  anchorBlock      ( ) const;
#endif

virtual IMessageQueueHandle
  messageQueue     ( ),
  messageQueue     ( ) const;


/*-------------------------- Current Thread Support --------------------------*/
#ifndef IC_MOTIFWIN_FLAGNOP
virtual unsigned long
  remainingStack        ( ) const;
#endif

virtual ICurrentThread
 &sleep                 ( unsigned long milliseconds );

virtual ICurrentThread
 &waitFor               ( const IThread &anotherThread ),
 &waitForAllThreads     ( );

virtual IThreadId
  waitForAnyThread      ( );

virtual void
  exit                  ( unsigned long returnCode );


/*------------------------ Current Thread Information ------------------------*/
virtual IThreadId
  id ( ) const;
virtual IThreadHandle
  handle ( ) const;

/*----------------------- Starting and Stopping Threads ----------------------*/
virtual void
  suspend ( );

protected:
/*------------------------------- Constructors -------------------------------*/
  ICurrentThread ( );

/*------------------------------ Implementation ------------------------------*/
virtual IStartedThread
 *startedThread ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
virtual
 ~ICurrentThread ( );

/*--------------------------------- Private ----------------------------------*/
friend class IThread;

ICurrentThreadData
 *fCurrentThreadData;

}; // ICurrentThread

#pragma pack()

  #include <ithread.inl>

#endif /* _ITHREAD_ */
