#ifndef _ITITLE_
  #define _ITITLE_
/*******************************************************************************
* FILE NAME: ititle.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*    Declaration of the class:                                                 *
*      ITitle                                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <itextctl.hpp>
#include <ireslib.hpp>

class IString;
class IColor;
class ITitleData;

#pragma pack(4)

class ITitle : public ITextControl {
typedef  ITextControl
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  ITitle ( IWindow*           owner,
           const char*        objectName = 0,
           const char*        viewName   = 0,
           unsigned long      viewNumber = 0);

  ITitle ( IWindow*           owner,
           const IResourceId& objectName,
           const IResourceId& viewName   = 0,
           unsigned long      viewNumber = 0);

virtual
  ~ITitle ( );

/*--------------------------- Text Processing --------------------------------*/

virtual ITitle
 &setText    ( const char* text ),
 &setText    ( const IResourceId& textResId );

virtual IString
  text       ( ) const;

virtual unsigned long
  textLength ( ) const;

/*--------------------------- Title Components -------------------------------*/
virtual IString
  objectText ( ) const,
  viewText   ( ) const;

virtual ITitle
 &setObjectText ( const char*       objectName ),
 &setObjectText ( const IResourceId& objectNameResId ),
 &setViewText   ( const char*       viewName ),
 &setViewText   ( const IResourceId& viewNameResId ),
 &setViewNumber ( unsigned long     viewNumber ),
 &setTitleText  ( const char*       objectName,
                  const char*       viewName          = 0,
                  unsigned long     viewNum           = 0 ),
 &setTitleText  ( const IResourceId& objectNameResId,
                  const IResourceId& viewNameResId    = 0,
                  unsigned long     viewNum           = 0 );

unsigned long
  viewNumber() const;

/*--------------------------------- Colors -----------------------------------*/
#ifndef IC_MOTIFWIN_FLAGNOP
virtual IColor
  borderColor                 () const,
  activeColor                 () const,
  inactiveColor               () const,
  activeTextForegroundColor   () const,
  activeTextBackgroundColor   () const,
  inactiveTextForegroundColor () const,
  inactiveTextBackgroundColor () const;

virtual ITitle
  &setActiveTextForegroundColor     (const IColor& color),
  &setActiveTextBackgroundColor     (const IColor& color),
  &setInactiveTextForegroundColor   (const IColor& color),
  &setInactiveTextBackgroundColor   (const IColor& color),
  &resetActiveTextForegroundColor   (),
  &resetActiveTextBackgroundColor   (),
  &resetInactiveTextForegroundColor (),
  &resetInactiveTextBackgroundColor ();
#endif // IC_MOTIFWIN_FLAGNOP

/*----------------------- Notification Event Descriptions --------------------*/
// Attribute Change Notifications
static INotificationId const
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU activeTextForegroundColorId,
  IC_IMPORTU activeTextBackgroundColorId,
  IC_IMPORTU inactiveTextForegroundColorId,
  IC_IMPORTU inactiveTextBackgroundColorId,
#endif
  IC_IMPORTU objectTextId,
  IC_IMPORTU viewTextId,
  IC_IMPORTU viewNumberId;

/*-------------------------- Observer Notification ---------------------------*/
virtual ITitle
  &enableNotification (Boolean enable = true);


/*-------------------------------- Attributes --------------------------------*/
virtual IWindow
 *owner                     ( ) const;

virtual Boolean
  isValid                   ( ) const;

virtual IWindowHandle
  handle                    ( ) const;

virtual IRectangle
  nativeRect                ( ) const;

virtual ISize
  parentSize                ( ) const;

protected:

private:
/*------------------------------ Hidden Members ------------------------------*/
  ITitle       (const ITitle& title );
ITitle
 &operator=    (const ITitle& title );

/*--------------------------------- Private ----------------------------------*/
IWindow
 *pwinClOwner;

ITitleData
 *fTitleData;

};

#pragma pack()

#endif  /* ifndef _ITITLE_ */
