
#ifndef _ITRACE_
#define _ITRACE_
/*******************************************************************************
* FILE NAME: itrace.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ITrace                                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>

#pragma pack(4)



class IString;

class ITrace : public IVBase {
typedef IVBase
  Inherited;

friend class ITraceSetup;

public:
/*------------------------- Constructors -------------------------------------*/
  ITrace                   ( const char* traceName =0,
                             long        lineNumber=0 );

 ~ITrace                   ( );

/*-------------------------- Output/Location ---------------------------------*/
static void
  write                    ( const IString& text ),
  write                    ( const char*    text );

enum Destination           {
  queue,
  standardError,
  standardOutput,
  file
  };

static ITrace::Destination
  traceDestination         ( );

static void
  writeToQueue             ( ),
  writeToStandardError     ( ),
  writeToStandardOutput    ( ),
  writeToFile              ( );

/*------------------------- Enable/Disable -----------------------------------*/
static void
  enableTrace              ( ),
  disableTrace             ( );

static Boolean
  isTraceEnabled           ( );

/*------------------------- Formatting ---------------------------------------*/
static void
  enableWriteLineNumber    ( ),
  disableWriteLineNumber   ( ),
  enableWritePrefix        ( ),
  disableWritePrefix       ( );

static Boolean
  isWriteLineNumberEnabled ( ),
  isWritePrefixEnabled     ( );


protected:
/*------------------------- Thread ID ----------------------------------------*/
static unsigned long
  threadId                 ( );

/*------------------------- Protected Output Operations ----------------------*/
static void
  writeString              ( char*          text   ),
  writeFormattedString     ( const IString& string,
                             char*          marker );

private:
/*------------------------- Private ------------------------------------------*/

enum State {
  uninitialized=1,
  on=2,
  writeLineNumber=4,
  writePrefix=8
  };
char
 *pszClTraceName;
static int
  iClState;
static ITrace::Destination
  iClTraceLocation;
static unsigned long
  remainingStack ( );




};




#ifndef __FUNCTION__
  #define __FUNCTION__ "f"
#endif

#ifdef IC_TRACE_ALL
   #define IMODTRACE_ALL(modname)  ITrace trc(modname, __LINE__ )
   #define IFUNCTRACE_ALL()        ITrace trc(__FUNCTION__, __LINE__ )
   #define ITRACE_ALL(p1)          ITrace::write(p1)
   #ifndef IC_TRACE_DEVELOP
     #define IC_TRACE_DEVELOP
   #endif
#else
   #define IMODTRACE_ALL(modname)
   #define IFUNCTRACE_ALL()
   #define ITRACE_ALL(p1)
#endif

#ifdef IC_TRACE_DEVELOP
   #define IMODTRACE_DEVELOP(modname) ITrace trc(modname,  __LINE__ )
   #define IFUNCTRACE_DEVELOP()       ITrace trc(__FUNCTION__, __LINE__ )
   #define ITRACE_DEVELOP(p1)         ITrace::write(p1)
   #ifndef IC_TRACE_RUNTIME
     #define IC_TRACE_RUNTIME
   #endif
#else
   #define IMODTRACE_DEVELOP(modname)
   #define IFUNCTRACE_DEVELOP()
   #define ITRACE_DEVELOP(p1)
#endif

#ifdef IC_TRACE_RUNTIME
   #define IMODTRACE_RUNTIME(modname)  ITrace trc(modname, __LINE__ )
   #define IFUNCTRACE_RUNTIME()        ITrace trc(__FUNCTION__, __LINE__ )
   #define ITRACE_RUNTIME(p1)          ITrace::write(p1)
#else
   #define IMODTRACE_RUNTIME(modname)
   #define IFUNCTRACE_RUNTIME()
   #define ITRACE_RUNTIME(p1)
#endif

#pragma pack()

  #include <itrace.inl>

#endif /* _ITRACE_ */



