#ifndef _ITRNSFRM_
#define _ITRNSFRM_
/*******************************************************************************
* FILE NAME: itrnsfrm.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ITransformMatrix                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>
#include <ipoint.hpp>


class ITransformData;
struct _MATRIXLF;
struct tagXFORM;

#pragma pack(4)

class ITransformMatrix : public IBase {
typedef IBase
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  ITransformMatrix  ( );

  ITransformMatrix  ( double                  element11,
                      double                  element12,
                      double                  element21,
                      double                  element22,
                      long                    element31,
                      long                    element32       );

  ITransformMatrix  ( const struct tagXFORM&  tagxform        );

  ITransformMatrix  ( const ITransformMatrix& transformMatrix );

ITransformMatrix
  &operator=        ( const ITransformMatrix& matrix          );

  ~ITransformMatrix ( );

/*----------------------------- Matrix Elements ------------------------------*/
ITransformMatrix
  &setElement11        ( double value ),
  &setElement12        ( double value ),
  &setElement21        ( double value ),
  &setElement22        ( double value ),
  &setElement31        ( long   value ),
  &setElement32        ( long   value );

double
  element11            ( ) const,
  element12            ( ) const,
  element21            ( ) const,
  element22            ( ) const;
long
  element31            ( ) const,
  element32            ( ) const;

ITransformMatrix
  &setToIdentity ( );


struct tagXFORM
  asTagXFORM     ( ) const;

/*--------------------------- Scale/Rotate/Translate -------------------------*/
ITransformMatrix
  &scaleBy      ( double        xScale,
                  double        yScale,
                  const IPoint& point = IPoint(0,0) ),
  &rotateBy     ( double        angle,
                  const IPoint& point = IPoint(0,0) ),
  &translateBy  ( const IPoint& point               );

/*------------------------------ Comparison ----------------------------------*/
IBase::Boolean
  operator== ( const ITransformMatrix& transformMatrix ) const,
  operator!= ( const ITransformMatrix& transformMatrix ) const;

private:
/*-------------------------------- Private -----------------------------------*/
ITransformData
 *fTransformData;

}; // ITransformMatrix

#pragma pack()

#endif // _ITRNSFRM_
