#ifndef _IVBCNROB_
  #define _IVBCNROB_
/*******************************************************************************
* FILE NAME: ivbcnrob.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IVBContainerObject                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992-1997        *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <icnrobj.hpp>

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

class IVBContainerObject : public IContainerObject {
public:
  IVBContainerObject       ( const IString&         string,
                             const IPointerHandle&  iconHandle = 0 );

IVBContainerObject
 &operator=                ( const IVBContainerObject&  aObject );

virtual IVBContainerObject
 &refreshFromObject        ( ) = 0;
virtual IVBContainerObject
 &updateToObject           ( ) = 0;

IString
  asString                 ( ) const;

};  // IVBContainerObject

#endif  /*  _IVBCNROB_  */
