#if (defined(__IBMC__) || defined(__IBMCPP__))
#pragma info( none )
#ifndef __CHKHDR__
   #pragma info( none )
#endif
#pragma info( restore )
#endif

#ifndef __localdef_h
   #define __localdef_h

   #ifdef __cplusplus
      extern "C" {
   #endif

   #ifndef  _LNK_CONV
     #ifdef _M_I386
         #define  _LNK_CONV   _Optlink
     #else
       #define  _LNK_CONV
     #endif
   #endif

   /********************************************************************/
   /*  <localdef.h> header file                                        */
   /*                                                                  */
   /*  VisualAge for C++ for Windows, Version 3.5                      */
   /*    Licensed Material - Property of IBM                           */
   /*                                                                  */
   /*  5801-ARR and Other Materials                                    */
   /*                                                                  */
   /*  (c) Copyright IBM Corp 1991, 1996. All rights reserved.         */
   /*                                                                  */
   /********************************************************************/

#include <limits.h>
#include <lc_core.h>
#include <locale.h>
#include <collate.h>


 /* _LC_charmap_t
 **
 ** Structure representing CHARMAP class which maps characters to process code
 ** and vice-verse.
 */
typedef struct {

    _LC_core_charmap_t core;

    char     *cm_csname;           /* codeset name                          */

    size_t   cm_mb_cur_max;        /* max encoding length for this codeset  */
    size_t   cm_mb_cur_min;        /* min encoding length for this codeset  */

    unsigned char
             cm_max_disp_width;    /* max display width of any char         */
                                   /* in the codeset */

    unsigned
        char *cm_cstab;            /* character set id table.               */

} _LC_charmap_t;


 /* _LC_monetary_t
 **
 ** Structure representing MONETARY class which defines the formatting
 ** of monetary quantities for a locale.
 */
typedef        struct {

    _LC_core_monetary_t   core;

    char *int_curr_symbol;         /* international currency symbol         */
    char *currency_symbol;         /* national currency symbol              */
    char *mon_decimal_point;       /* currency decimal point                */
    char *mon_thousands_sep;       /* currency thousands separator          */
    char *mon_grouping;            /* currency digits grouping              */
    char *positive_sign;           /* currency plus sign                    */
    char *negative_sign;           /* currency minus sign                   */
    signed char int_frac_digits;   /* internat currency fract digits        */
    signed char frac_digits;       /* currency fractional digits            */
    signed char p_cs_precedes;     /* currency plus location                */
    signed char p_sep_by_space;    /* currency plus space ind.              */
    signed char n_cs_precedes;     /* currency minus location               */
    signed char n_sep_by_space;    /* currency minus space ind.             */
    signed char p_sign_posn;       /* currency plus position                */
    signed char n_sign_posn;       /* currency minus position               */
    char *debit_sign;              /* currency debit symbol                 */
    char *credit_sign;             /* currency credit symbol                */
    char *left_parenthesis;        /* currency left parenthesis             */
    char *right_parenthesis;       /* currency right parenthesis            */

} _LC_monetary_t;

 /* _LC_numeric_t
 **
 ** Structure representing NUMERIC class which defines the formatting
 ** of numeric quantities in a locale.
 */
typedef struct {

    _LC_core_numeric_t core;

    char     *decimal_point;
    char     *thousands_sep;
    unsigned
        char *grouping;

} _LC_numeric_t;


 /* _LC_resp_t
 **
 ** Structure representing RESPONSE class which defines the content
 ** of affirmative versus negative responses in a locale.
 */
typedef struct  {

    _LC_core_resp_t core;

    char    *yesexpr;             /* POSIX: Expression for affirmative. */
    char    *noexpr;              /* POSIX: Expression for negative.    */

} _LC_resp_t;

 /* _LC_syntax_t
 **
 ** Structure representing the SYNTAX class which defines the characters used by
 ** the C/370 compiler that vary across the EBCDIC code pages.
 */
typedef struct {

    _LC_core_syntax_t core;

    char          *sx_csname;            /* codeset name */

    unsigned char *backslash;
    unsigned char *right_brace;
    unsigned char *left_brace;
    unsigned char *right_bracket;
    unsigned char *left_bracket;
    unsigned char *circumflex;
    unsigned char *tilde;
    unsigned char *exclamation_mark;
    unsigned char *number_sign;
    unsigned char *vertical_line;
    unsigned char *dollar_sign;
    unsigned char *commercial_at;
    unsigned char *grave_accent;

} _LC_syntax_t;


 /* _LC_tod_t
 **
 ** Structure representing the TOD class which defines the time zone names
 ** and start and end times for daylight saving.
 */
typedef struct {

    _LC_core_tod_t core;

    int   tzdiff;     /* Time zone differences in minutes              */
    char *tname;      /* Time zone name                                */
    char *tzname;     /* Daylight saving time zone name                */
    int   dststm;     /* Month of year when daylight saving starts     */
    int   dstenm;     /* Month of year when daylight saving ends       */
    int   dststw;     /* Week of month when daylight saving starts     */
    int   dstenw;     /* Week of month when daylight saving ends       */
    int   dststd;     /* Day of week/month when daylight saving starts */
    int   dstend;     /* Day of week/month when daylight saving ends   */
    int   starttm;    /* Start time in seconds after midnight          */
    int   endtm;      /* End time in seconds after midnight            */
    int   shift;      /* DST time shift, expressed in seconds          */
    char *uctname;    /* Coordinated Universal Time                    */

} _LC_tod_t;


 /* _LC_time_t
 **
 ** Structure representing the TIME class which defines the formatting
 ** of time and date quantities in this locale.
 */
typedef struct {

    _LC_core_time_t core;

    char *d_fmt;
    char *t_fmt;
    char *d_t_fmt;
    char *t_fmt_ampm;
    char *abday[7];
    char *day[7];
    char *abmon[12];
    char *mon[12];
    char *am_pm[2];
    char *era;
    char *era_year;
    char *era_d_fmt;
    char **alt_digits;
    short num_digits;
    struct dtconv  *nl_dtconv;

} _LC_time_t;


 /* _LC_weight_t
 **
 ** Array of collation weights for a character or collating symbol.
 */
typedef union {
    unsigned                       /* This type is used if the number of  */
        short  n[2];               /* collation orders is <= 2            */

    unsigned                       /* This type is used if the number of  */
        short  *p;                 /* collation orders is > 2             */
} _LC_weight_t;


 /* _LC_collel_t
 **
 ** Collation data for a collation symbol
 */
typedef struct {

    char         *ce_sym;          /* value of collation symbol           */
    _LC_weight_t ce_wgt;           /* The weights associated with a       */
                                   /* collating symbol matching ce_sym    */
    collel_t     collel;           /* collating element value             */
    short        collel_idx;       /* Index into collel_t array           */
    short        collel_equiv;     /* Number of equivalent elements       */
} _LC_collel_t;


 /* _LC_coltbl_t
 **
 ** Array of per-character collation data for locale.
 */
typedef struct {
    _LC_weight_t   ct_wgt;         /* The collation weights for this      */
                                   /* character.                          */

    _LC_collel_t   *ct_collel;     /* Pointer to collation symbol array   */

    short          collel_idx;     /* Index into collel_t array           */
    short          collel_equiv;   /* Number of equivalent elements       */
} _LC_coltbl_t;


#if !defined(COLL_WEIGHTS_MAX)
  #define _COLL_WEIGHTS_MAX  6
#else
  #define _COLL_WEIGHTS_MAX COLL_WEIGHTS_MAX
#endif
 /* _LC_subs_t
 **
 ** Substring source and target pair
 */
typedef struct {

    _LC_weight_t ss_act;           /* indicates for which orders this */
                                   /* susbstitution string is active. */
    char *ss_src;                  /* source string to match          */
    char *ss_tgt;                  /* target string to replace        */

} _LC_subs_t;

 /* _LC_colstr_t
 **
 ** Collating element strings
 */
typedef struct {
    char        *collelc;          /* Collating Element string        */
    wchar_t     *collelwc;         /* Collating Element Wide string   */
    collel_t     collel;           /* collating element value         */
    short        collel_idx;       /* Index into collel_t array       */
    short        collel_equiv;     /* Number of equivalent elements   */
} _LC_colstr_t;

 /* _LC_collate_t
 **
 ** Structure representing COLLATE class defining the collation rules
 ** for a locale.
 */
typedef struct {

    _LC_core_collate_t core;

    unsigned                       /* number of collation orders      */
        char    co_nord;           /* supported in this locale        */

    _LC_weight_t co_sort;          /* sort order                      */
                                   /* processing flags                */

    wchar_t     co_wc_min;         /* min process code                */
    wchar_t     co_wc_max;         /* max process code                */

    wchar_t     co_col_min;        /* min coll weight                 */
    wchar_t     co_col_max;        /* max coll weight                 */

    _LC_coltbl_t *co_coltbl;       /* array of collation              */
                                   /* weights, symbols                */
    unsigned
        char    co_nsubs;          /* number of sub strs              */
    _LC_subs_t  *co_subs;          /* substitution strs               */

    short         ncolstr;         /* number of multi-char strings    */
    _LC_colstr_t  *colstr;         /* Collation strs                  */

    const collel_t *colleltbl;     /* Sorted collation table          */
    short          ncollel;        /* number of collel entries        */

} _LC_collate_t;

 /*
 ** MASKS for the co_sort[] sort modifier array
 */
#define _COLL_FORWARD_MASK   1
#define _COLL_BACKWARD_MASK  2
#define _COLL_NOSUBS_MASK    4
#define _COLL_POSITION_MASK  8

 /*
 ** MASKS for the ss_act[] flags
 */
#define _SUBS_ACTIVE         1
#define _SUBS_REGEXP         2

 /* _LC_classnm_t
 **
 ** Element mapping class name to a bit-unique mask.
 */
typedef struct {

    char           *name;
    unsigned int    mask;
    const collel_t *collist;     /* collel's for chars in class */
    int             colcount;     /* numbers of collel's         */

} _LC_classnm_t;


 /* _LC_ctype_t
 **
 ** Structure representing CTYPE class which defines character
 ** membership in a character class.
 */
typedef struct {

  _LC_core_ctype_t core;

  /* min and max process code */
  wchar_t      min_wc;
  wchar_t      max_wc;

  /* upper, lower translation */
  char         *upperidx;   /* toupper() index array    */
  char         *loweridx;   /* tolower() index array    */
  wchar_t      *upper;      /* toupper() translation    */
  wchar_t      *lower;      /* tolower() translation    */

  /* character class membership */
  unsigned
    short      *ctable;       /* masks/upper/lower for CP 0..255   */
  unsigned
    short      *cmask;        /* is() mask for user classes 0..255 */
  unsigned
      int      *mask;         /* isw() masks                       */
  char         *ctypeidx;     /* isw() index array                 */

  /* class name mapping */
  unsigned char        nclasses;
  _LC_classnm_t *classnms;

} _LC_ctype_t;


 /* _LC_locale_t
 **
 ** Entry point to locale database.  setlocale() receives a pointer to
 ** this structure from __lc_load().
 */

 /**********
 ** IF THIS NUMBER CHANGES, IT MUST ALSO BE CHANGED IN
 ** inc/langinfo.h
 **********/
#define _NL_NUM_ITEMS 51
typedef struct {

    _LC_core_locale_t core;

    char           *nl_info[_NL_NUM_ITEMS];
    struct lconv   *nl_lconv;

    _LC_charmap_t  *lc_charmap;
    _LC_collate_t  *lc_collate;
    _LC_ctype_t    *lc_ctype;
    _LC_monetary_t *lc_monetary;
    _LC_numeric_t  *lc_numeric;
    _LC_resp_t     *lc_resp;
    _LC_time_t     *lc_time;
    _LC_tod_t      *lc_tod;
    _LC_syntax_t   *lc_syntax;

} _LC_locale_t;

#define _LC_MAX_OBJECTS   256

extern _LC_charmap_t  * _IMPORT __lc_charmap;
extern _LC_collate_t  * _IMPORT __lc_collate;
extern _LC_ctype_t    * _IMPORT __lc_ctype;
extern _LC_monetary_t * _IMPORT __lc_monetary;
extern _LC_numeric_t  * _IMPORT __lc_numeric;
extern _LC_resp_t     * _IMPORT __lc_resp;
extern _LC_time_t     * _IMPORT __lc_time;
extern _LC_syntax_t   * _IMPORT __lc_syntax;
extern _LC_tod_t      * _IMPORT __lc_tod;
extern _LC_locale_t   * _IMPORT __lc_locale;

typedef struct {

    void    *(*malloc_ptr)();      /* Address of malloc function   */
    void     (*free_ptr)();        /* Address of free function     */
    char    *(*_fcvt_ptr)();       /* Address of _fcvt function    */
    int      (*atoi_ptr)();        /* Address of atoi function     */
    void    *pglobal_ptr;          /* Address of PGLOBAL           */

} _LC_passvar_t;

typedef struct {

    _LC_locale_t         **lc_locale;
    _LC_ctype_t          **lc_ctype;
    _LC_charmap_t        **lc_charmap;
    _LC_collate_t        **lc_collate;
    _LC_monetary_t       **lc_monetary;
    _LC_numeric_t        **lc_numeric;
    _LC_time_t           **lc_time;
    _LC_resp_t           **lc_resp;
    _LC_syntax_t         **lc_syntax;
    _LC_tod_t            **lc_tod;
    const unsigned short **_ctype;
    const unsigned char  **_ctype_upperidx;
    const unsigned char  **_ctype_loweridx;
    const wchar_t        **_ctype_upper;
    const wchar_t        **_ctype_lower;
    const unsigned char  **_ctype_ctypeidx;
    const unsigned short **_ctype_cmask;
    const unsigned int   **_ctype_mask;
    int                   *_mb_cur_max;
} _LC_setvar_t;

   #ifdef __cplusplus
      }
   #endif

#endif

#if (defined(__IBMC__) || defined(__IBMCPP__))
#pragma info( none )
#ifndef __CHKHDR__
   #pragma info( restore )
#endif
#pragma info( restore )
#endif

