#ifndef __som_new_h
   #define __som_new_h

   /********************************************************************/
   /*  <somnew.h> header file                                          */
   /*                                                                  */
   /*  VisualAge for C++ for Windows, Version 3.5                      */
   /*    Licensed Material - Property of IBM                           */
   /*                                                                  */
   /*  5801-ARR and Other Materials                                    */
   /*                                                                  */
   /*  (c) Copyright IBM Corp 1991, 1996. All rights reserved.         */
   /*                                                                  */
   /********************************************************************/
   #include <stddef.h>

   #if __SOM_ENABLED__
   // The SOM versions of the standard favourites

   #ifndef __DEBUG_ALLOC__
      void *operator new(SOMClass *cl, size_t size);
      void *operator new(SOMClass *cl, size_t size, void *location);

      void *operator new[](SOMClass *cl, size_t size);
      void *operator new[](SOMClass *cl, size_t size, void *location);

      void operator delete(SOMObject *location);

      void operator delete[](SOMObject *location);
   #else
      #include <stdlib.h>

      void *operator new(SOMClass *cl, size_t size, const char *filename, size_t lineno);
      void *operator new(SOMClass *cl, size_t size, const char *filename, size_t lineno, void *location);

      void *operator new[](SOMClass *cl, size_t size, const char *filename, size_t lineno);
      void *operator new[](SOMClass *cl, size_t size, const char *filename, size_t lineno, void *location);

      void operator delete(SOMObject *location, const char *filename, size_t lineno);

      void operator delete[](SOMObject *location, const char *filename, size_t lineno);
   #endif
   #endif

#endif
