   /********************************************************************/
   /*  <tchar.h> header file                                           */
   /*                                                                  */
   /*  VisualAge for C++ for Windows, Version 3.5                      */
   /*    Licensed Material - Property of IBM                           */
   /*                                                                  */
   /*  5801-ARR and Other Materials                                    */
   /*                                                                  */
   /*  (c) Copyright IBM Corp 1991, 1996. All rights reserved.         */
   /*                                                                  */
   /********************************************************************/

#ifndef __tchar_h
   #define __tchar_h

   #ifdef __cplusplus
      extern "C" {
   #endif

   #ifdef _UNICODE

      #include <wchar.h>

      #ifndef __tchar
         typedef wchar_t _TCHAR;
         #define __tchar
      #endif

      #ifndef __tint
         typedef wint_t _TINT;
         #define __tint
      #endif

      #define _TEOF     WEOF

      #define __T(x)    L ## x


      #define _tprintf     wprintf
      #define _ftprintf    fwprintf
      #define _stprintf    swprintf
      #define _vtprintf    vwprintf
      #define _vftprintf   vfwprintf
      #define _vstprintf   vswprintf
      #define _tscanf      wscanf
      #define _stscanf     swscanf


      #define _fgettc      fgetwc
      #define _fgetts      fgetws
      #define _fputtc      fputwc
      #define _fputts      fputws
      #define _gettc       getwc
      #define _gettchar    getwchar
      #define _puttc       putwc
      #define _puttchar    putwchar
      #define _ungettc     ungetwc


      #define _tcstod      wcstod
      #define _tcstol      wcstol
      #define _tcstoul     wcstoul


      #define _tcscat      wcscat
      #define _tcschr      wcschr
      #define _tcscmp      wcscmp
      #define _tcscpy      wcscpy
      #define _tcscspn     wcscspn
      #define _tcslen      wcslen
      #define _tcsncat     wcsncat
      #define _tcsncmp     wcsncmp
      #define _tcsncpy     wcsncpy
      #define _tcspbrk     wcspbrk
      #define _tcsrchr     wcsrchr
      #define _tcsspn      wcsspn
      #define _tcsstr      wcsstr
      #define _tcstok      wcstok


      #define _tcsclen     wcslen
      #define _tcsnccat    wcsncat
      #define _tcsnccpy    wcsncpy
      #define _tcsnccmp    wcsncmp

      #define _tcsxfrm     wcsxfrm
      #define _tcscoll     wcscoll


      #define _istalpha    iswalpha
      #define _istupper    iswupper
      #define _istlower    iswlower
      #define _istdigit    iswdigit
      #define _istxdigit   iswxdigit
      #define _istspace    iswspace
      #define _istpunct    iswpunct
      #define _istalnum    iswalnum
      #define _istprint    iswprint
      #define _istgraph    iswgraph
      #define _istcntrl    iswcntrl

      #define _totupper    towupper
      #define _totlower    towlower

   #else

      #include <string.h>
      #include <stdio.h>

      #ifndef __tchar
         typedef char _TCHAR;
         #define __tchar
      #endif

      #ifndef __tint
         typedef int _TINT;
         #define __tint
      #endif

      #define _TEOF     EOF

      #define __T(x)            x


      #define _tprintf     printf
      #define _ftprintf    fprintf
      #define _stprintf    sprintf
      #define _vtprintf    vprintf
      #define _vftprintf   vfprintf
      #define _vstprintf   vsprintf
      #define _tscanf      scanf
      #define _ftscanf  fscanf
      #define _stscanf  sscanf


      #define _fgettc      fgetc
      #define _fgetts      fgets
      #define _fputtc      fputc
      #define _fputts      fputs
      #define _gettc       getc
      #define _gettchar    getchar
      #define _puttc       putc
      #define _puttchar    putchar
      #define _ungettc     ungetc


      #define _tcstod      strtod
      #define _tcstol      strtol
      #define _tcstoul     strtoul


      #define _tcscat      strcat
      #define _tcschr      strchr
      #define _tcscmp      strcmp
      #define _tcscpy      strcpy
      #define _tcscspn     strcspn
      #define _tcslen      strlen
      #define _tcsncat     strncat
      #define _tcsncmp     strncmp
      #define _tcsncpy     strncpy
      #define _tcspbrk     strpbrk
      #define _tcsrchr     strrchr
      #define _tcsspn      strspn
      #define _tcsstr      strstr
      #define _tcstok      strtok

      #define _tcsdup      strdup
      #define _tcsicmp     stricmp
      #define _tcsnicmp    strnicmp
      #define _tcsnset     strnset
      #define _tcsrev      strrev
      #define _tcsset      _strset


      #define _tcsclen     strlen
      #define _tcsnccat    strncat
      #define _tcsnccpy    strncpy
      #define _tcsnccmp    strncmp
      #define _tcsncicmp   strnicmp
      #define _tcsncset    strnset

      #define _tcsxfrm     strxfrm
      #define _tcscoll     strcoll


      #define _istalpha    isalpha
      #define _istupper    isupper
      #define _istlower    islower
      #define _istdigit    isdigit
      #define _istxdigit   isxdigit
      #define _istspace    isspace
      #define _istpunct    ispunct
      #define _istalnum    isalnum
      #define _istprint    isprint
      #define _istgraph    isgraph
      #define _istcntrl    iscntrl
      #define _istascii    isascii

      #define _totupper toupper
      #define _totlower tolower


   #endif

   #define _T(x)                __T(x)
   #define _TEXT(x)     __T(x)

   #ifdef __cplusplus
      }
   #endif

#endif

