#ifndef _H_TYPEINFO_
#define _H_TYPEINFO_
/********************************************************************/
/*  <typeinfo.h> header file                                        */
/*                                                                  */
/*  VisualAge for C++ for Windows, Version 3.5                      */
/*    Licensed Material - Property of IBM                           */
/*                                                                  */
/*  5801-ARR and Other Materials                                    */
/*                                                                  */
/*  (c) Copyright IBM Corp 1991, 1996. All rights reserved.         */
/*                                                                  */
/********************************************************************/

#include <string.h>

class type_info {
  public:
    typedef int         Bool;   // typedef to 'bool' when it is supported.

    virtual             ~type_info();
    Bool                operator==(const type_info&) const;
    Bool                operator!=(const type_info&) const;
    Bool                before(const type_info&) const;
    const char*         name() const;

  private:
                        type_info(const type_info&);
    type_info&          operator=(const type_info&);

  protected:
    char *              typeName;
    char *              mangledName;
};

class extended_type_info : public type_info {
  public:
                        ~extended_type_info();
    virtual size_t      size() const=0;
    virtual void*       create(void* at) const=0;
    virtual void*       create(void* at, size_t count) const=0;
    virtual void*       copy(void* to, const void* from) const=0;
    virtual void*       copy(void* to, const void* from, size_t count) const=0;
    virtual void*       destroy(void* at) const=0;
    virtual void*       destroy(void* at, size_t count) const=0;
    virtual void*       allocObject() const=0;
    virtual void*       allocArray(size_t count) const=0;
    virtual void        deallocObject(void* at) const=0;
    virtual void        deallocArray(void* at, size_t count) const=0;
    virtual const void* linkageInfo() const=0;

  private:
                        extended_type_info(const extended_type_info&);
    extended_type_info& operator=(const extended_type_info&);
};

inline const char * type_info::name() const {
  return typeName;
}

inline type_info::Bool type_info::operator==(const type_info&x) const {
  return (&x==this) || (strcmp(x.mangledName,this->mangledName)==0);
}

inline type_info::Bool type_info::operator!=(const type_info&x) const {
  return (&x!=this) && (strcmp(x.mangledName,this->mangledName)!=0);
}

inline type_info::Bool type_info::before(const type_info&x) const {
  return (&x!=this) && (strcmp(x.mangledName,this->mangledName)>=0);
}

#endif /* _H_TYPEINFO_ */
