//+----------------------------------------------------------------------------+
//| PROGRAM NAME: AUTHORS1.CPP                                                 |
//| ------------                                                               |
//|                                                                            |
//| COPYRIGHT:                                                                 |
//| ----------                                                                 |
//|  Copyright (C) International Business Machines Corp., 1992,1993.           |
//|                                                                            |
//| DISCLAIMER OF WARRANTIES:                                                  |
//| -------------------------                                                  |
//|  The following [enclosed] code is sample code created by IBM Corporation.  |
//|  This sample code is not part of any standard IBM product and is provided  |
//|  to you solely for the purpose of assisting you in the development of      |
//|  your applications.  The code is provided "AS IS", without warranty of     |
//|  any kind.  IBM shall not be liable for any damages arising out of your    |
//|  use of the sample code, even if they have been advised of the             |
//|  possibility of such damages.                                              |
//|                                                                            |
//| REVISION LEVEL: 1.0                                                        |
//| ---------------                                                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
//| Purpose     : Demonstrates use of the DataInTree class to store author     |
//|               and book data in the n-ary tree container.                   |
//| Author      : njC Sales                                                    |
//| Date        : 27 October 1992                                              |
//+----------------------------------------------------------------------------+

#include <stdio.h>
#include "datntree.hpp"

int main()
{
   char *authors[] = {"Asimov, Isaac",
                      "Sales, Kevin Matthew",
                      "Stroustrup, Bjarne",
                      "Richie, Dennis"
                     };

   char *AIbooks[] = {"Foundation",
                      "I Robot",
                      "Caves of Steel"
                     };

   char *SKbooks[] = {"Compiler Design",
                      "Man Machine Communication",
                      "I came, I C"
                     };

   char *SBbooks[] = {"C++ Programming Language",
                      "The ARM",
                     };

   char *RDbooks[] = {"C Programming Language",
                      "Yet another C",
                     };

   DataInTree          Mommy;
   DataInTree          *childWalker, *childWalker2;
   int index, ndx2;

   for (index= 0; index < sizeof(authors)/sizeof(char *); index++)
   {
      Mommy.addChild(new DataInTree(DataInTree(authors[index])));
   }

   printf("The Authors are.. tah dahhhhh\n");

   for (childWalker= (DataInTree *)Mommy.getChild();
        childWalker != NULL;
        childWalker= (DataInTree *)childWalker->getRight())
   {
      childWalker->display();
   }

   printf("Now Adding books to authors\n");

   for (index= 0, childWalker= (DataInTree *)Mommy.getChild();
        childWalker != NULL;
        index++,  childWalker= (DataInTree *)childWalker->getRight())
   {
      childWalker->display();
      switch(index)
      {
         case 0:
            for (ndx2= 0; ndx2 < sizeof(AIbooks)/sizeof(char *); ndx2++)
            {
               childWalker->addChild(new DataInTree(DataInTree(AIbooks[ndx2])));
            }
            break;

         case 1:
            for (ndx2= 0; ndx2 < sizeof(SKbooks)/sizeof(char *); ndx2++)
            {
               childWalker->addChild(new DataInTree(DataInTree(SKbooks[ndx2])));
            }
            break;

         case 2:
            for (ndx2= 0; ndx2 < sizeof(SBbooks)/sizeof(char *); ndx2++)
            {
               childWalker->addChild(new DataInTree(DataInTree(SBbooks[ndx2])));
            }
            break;

         case 3:
            for (ndx2= 0; ndx2 < sizeof(RDbooks)/sizeof(char *); ndx2++)
            {
               childWalker->addChild(new DataInTree(DataInTree(RDbooks[ndx2])));
            }
            break;

         default:
            break;
      }   // case end
   }   // for end

   for (childWalker= (DataInTree *)Mommy.getChild();
        childWalker != NULL;
        childWalker= (DataInTree *)childWalker->getRight())
   {
      printf ("Author tah dahh\n");
      childWalker->display();
      printf ("   wrote the following masterpieces\n");
      for (childWalker2= (DataInTree *)childWalker->getChild();
           childWalker2 != NULL;
           childWalker2= (DataInTree *)childWalker2->getRight())
      {
         childWalker2->display();
      }
   }

   printf("Test Tree Surgery Asimov Goes to another mommy\n");

   DataInTree   AsMom, *AsPtr= (DataInTree *)Mommy.getChild();
   AsMom.addChild(AsPtr);

   printf("Test Tree Surgery Asimov Goes to another mommy ok\n");

   printf("Print the remaining family Tree\n");

   for (childWalker= (DataInTree *)Mommy.getChild();
        NULL != childWalker;
        childWalker= (DataInTree *)childWalker->getRight())
   {
      printf ("Author tah dahh\n");
      childWalker->display();
      printf ("   wrote the following masterpieces\n");
      for (childWalker2= (DataInTree *)childWalker->getChild();
           NULL != childWalker2;
           childWalker2= (DataInTree *)childWalker2->getRight())
      {
         childWalker2->display();
      }
   }

   printf("Print Asimov family Tree\n");

   for (childWalker= (DataInTree *)AsMom.getChild();
        NULL != childWalker;
        childWalker= (DataInTree *)childWalker->getRight())
   {
      printf ("Author tah dahh\n");
      childWalker->display();
      printf ("   wrote the following masterpieces\n");
      for (childWalker2= (DataInTree *)childWalker->getChild();
           NULL != childWalker2;
           childWalker2= (DataInTree *)childWalker2->getRight())
      {
         childWalker2->display();
      }
   }
   printf("Test ended Successfully\n");
   return 0;
}   // main end
