//+----------------------------------------------------------------------------+
//| DATNTREE.CPP                                                               |
//|                                                                            |
//| COPYRIGHT:                                                                 |
//| ----------                                                                 |
//|  Copyright (C) International Business Machines Corp., 1992,1993.           |
//|                                                                            |
//| DISCLAIMER OF WARRANTIES:                                                  |
//| -------------------------                                                  |
//|  The following [enclosed] code is sample code created by IBM Corporation.  |
//|  This sample code is not part of any standard IBM product and is provided  |
//|  to you solely for the purpose of assisting you in the development of      |
//|  your applications.  The code is provided "AS IS", without warranty of     |
//|  any kind.  IBM shall not be liable for any damages arising out of your    |
//|  use of the sample code, even if they have been advised of the             |
//|  possibility of such damages.                                              |
//|                                                                            |
//| REVISION LEVEL: 1.0                                                        |
//| ---------------                                                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
//| Author      : njC Sales                                                    |
//| Date        : 27 October 1992                                              |
//+----------------------------------------------------------------------------+

#include "datntree.hpp"

//+----------------------------------------------------------------------------+
//| Define constructors                                                        |
//+----------------------------------------------------------------------------+
DataInTree::DataInTree(void *pString): TreeNode(), MyData(pString)
{
   if (NULL != pString)
      myState= TreeNode::Leaf;
}

DataInTree::DataInTree(DataInTree *pDataInTree): TreeNode(pDataInTree),
              MyData(pDataInTree->MyData)
{
   if (NULL != pDataInTree)
      myState= pDataInTree->myState;
}

DataInTree::DataInTree(const DataInTree &rDataInTree):
   TreeNode(rDataInTree),MyData(rDataInTree.MyData)
{
   myState= rDataInTree.myState;
}

//+----------------------------------------------------------------------------+
//| Assignment                                                                 |
//+----------------------------------------------------------------------------+
DataInTree &DataInTree::operator= (const DataInTree &rDataInTree)
{
   if (this != &rDataInTree)
   {
      *((TreeNode *)this)= rDataInTree;
      MyData= rDataInTree.MyData;
   }
   return *this;
}

//+----------------------------------------------------------------------------+
//| Display data                                                               |
//+----------------------------------------------------------------------------+
void DataInTree::display()
{
   printf("Data  = %s\n",(char *)MyData.getData());
   printf("State = %d\n",(short)getState());
}
