#ifndef _Car_HPP_
  #define _Car_HPP_

//***************************************************************************
// This code is generated by IBM VisualAge C++ Data Access Builder.
// WARNING: User modifications will be lost on next code generation.
//***************************************************************************


//***************************************************************************
// FILE NAME: Car.HPP
//
// DESCRIPTION:
//   Declaration of the classes:
//    CarId - persistent object class data identifier
//    Car - persistent object class
//    CarManagerBase - persistent object list abstract base manager class
//    CarManagerTemplate - persistent object list manager class template
//    CarManager - persistent object list manager class
//    CarDatastore - to access Car objects
//
//***************************************************************************

#ifndef Car_IMPORTEXPORT
  #define Car_IMPORTEXPORT _Import
#endif

#ifndef _ISTRING_
  #include <istring.hpp>
#endif

#ifndef _IPERSIST_
  #include <ipersist.hpp>
#endif

#ifndef _IPOATTR_
  #include <ipoattr.hpp>
#endif

#ifndef _ISTDNTFY_
  #include <istdntfy.hpp>
#endif

#ifndef _IOBSERVR_
  #include <iobservr.hpp>
#endif

#ifndef _IVSEQ_H_
  #include <ivseq.h>
#endif

#ifndef _ISTRGEN_
  #include <istrgen.hpp>
#endif

#ifndef _IDSEXC_HPP_
  #include <idsexc.hpp>
#endif

#ifndef _IDSMCOD_HPP_
  #include <idsmcod.hpp>
#endif


#ifndef __NO_DEFAULT_LIBS__
  #pragma library("Car.LIB")
#endif

#pragma pack(4)

//***************************************************************************
//
//    CarId - persistent object class data identifier
//
//***************************************************************************

class Car_IMPORTEXPORT CarDataId : public IStandardNotifier
{

  friend class Car;
  friend class CarManagerBase;
  friend class CarUpdateStatement;
  friend class CarUpdateDataIdStatement;
  friend class CarDeleteStatement;
  friend class CarAddStatement;
  friend class CarRetrieveStatement;
  friend class CarSelectStatement;

public:

  //***************************************************************************
  // Constructors
  //***************************************************************************
  CarDataId();
  CarDataId(
                const IString& aLicense);
  CarDataId(const CarDataId& partCopy);
  virtual ~CarDataId();

  //***************************************************************************
  // Operators
  //***************************************************************************
  CarDataId& operator= (const CarDataId& aCar);
  Boolean
    operator == (const CarDataId& value) const,
    operator != (const CarDataId& value) const,
    operator <  (const CarDataId& value) const,
    operator == (const CarDataId* value) const,
    operator != (const CarDataId* value) const,
    operator <  (const CarDataId* value) const;

public:

  //***************************************************************************
  // Access and control
  //***************************************************************************

  virtual IString forDisplay( const char* separator = " " ) const;
  IString asString( const char* separator ) const;
  IString asString() const { return asString("."); }

  //***************************************************************************
  // Visual Builder support
  //***************************************************************************
  virtual CarDataId& initializePart();
  static const INotificationId readyId;

protected:
  Boolean makeConnections();

  //***************************************************************************
  // Attribute Declarations
  //***************************************************************************

  //***************************************************************************
  // Declaration of license 
  //***************************************************************************
private:
  IPOStringAttribute iLicense;

  void getLicenseFromBuffer( class IPOBufferBase* aBuffer );

public:
  static const INotificationId licenseId;
  static const INotificationId licenseNullId;
  const IString& license() const { return iLicense.get(); }
  Boolean isLicenseNull() const { return iLicense.isNull(); }
  Boolean isLicenseNullable() const { return true; }
  IString licenseAsString() const { return iLicense.asString(); }

  CarDataId& setLicenseToNull(Boolean nullState=true);
  CarDataId& setLicense(const IString& aString );


};

//***************************************************************************
//
//    Car - persistent object class
//
//***************************************************************************

class Car_IMPORTEXPORT Car : public IPersistentObject
                          , public IStandardNotifier
{

private:
  CarDataId theDataId;
  class internalsObserver : public IObserver
  {
    private:
      IStandardNotifier* theNotifier;
    public:
      internalsObserver( IStandardNotifier* aNotifier ) : theNotifier(aNotifier) {}
      internalsObserver& dispatchNotificationEvent( const INotificationEvent& anEvent );
  } theInternalsObserver;

public:
  friend class CarManagerBase;

  typedef CarDataId DataId;

  //***************************************************************************
  // Constructors
  //***************************************************************************
  Car();
  Car( IDatastoreODBC* aCarDatastore );
  Car( const CarDataId& theDataId,
               IDatastoreODBC* aCarDatastore = 0 );
  Car(const Car& partCopy);
  virtual ~Car();

  //***************************************************************************
  // Operators
  //***************************************************************************
  Car& operator= (const Car& aCar);
  Boolean
    operator == (const Car& value) const,
    operator != (const Car& value) const,
    operator <  (const Car& value) const,
    operator == (const Car* value) const,
    operator != (const Car* value) const,
    operator <  (const Car* value) const;

  //***************************************************************************
  // Access and control
  //***************************************************************************


  const CarDataId& dataId() const { return theDataId; }
  Car& setDataId( const CarDataId& aDataId );
  Car& setDataId( const CarDataId* aDataId ) { return setDataId(*aDataId); }

  virtual IString forDisplay( const char* separator = " " ) const;
  virtual IString asString( const char* separator ) const;
  virtual IString asString() const { return asString("."); }
  IString asDebugInfo() const { return IPersistentObject::asDebugInfo(); }

  virtual Car& add();
  virtual Car& del();
  virtual Car& update();
  virtual Car& update( const CarDataId& aNewDataId );
  Car& update( const CarDataId* aNewDataId ) { return update(*aNewDataId); }
  virtual Car& retrieve ();

  Car& setReadOnly(Boolean flag = true);
  Car& setRetrievable(Boolean flag = true);

  static IDatastoreODBC* defaultDatastore();
  static void setDefaultDatastore( IDatastoreODBC* aDatastore = 0 );
  IDatastoreODBC* objectsDatastore() const;
  void setObjectsDatastore( IDatastoreODBC* aDatastore = 0 );
  IDatastoreODBC* currentDatastore() const;

  //***************************************************************************
  // Visual Builder support
  //***************************************************************************
  static const INotificationId retrievableId;
  static const INotificationId readOnlyId;
  static const INotificationId dataIdId;
  static const INotificationId readyId;
  static const INotificationId objectsDatastoreId;
  virtual Car& initializePart();

protected:
  Boolean makeConnections();


  //***************************************************************************
  // Internal declarations
  //***************************************************************************

private:
  static IDatastoreODBC* iCarDatastore;
  IDatastoreODBC* iObjectsDatastore;

  friend class CarUpdateStatement;
  friend class CarUpdateDataIdStatement;
  friend class CarDeleteStatement;
  friend class CarAddStatement;
  friend class CarRetrieveStatement;
  friend class CarSelectStatement;


  //***************************************************************************
  // Attribute Declarations
  //***************************************************************************

  //***************************************************************************
  // Declaration of license 
  //***************************************************************************
public:
  static const INotificationId licenseId;
  static const INotificationId licenseNullId;
  const IString& license() const { return theDataId.license(); }
  Boolean isLicenseNull() const { return theDataId.isLicenseNull(); }
  Boolean isLicenseNullable() const { return theDataId.isLicenseNullable(); }
  IString licenseAsString() const { return theDataId.licenseAsString(); }
  Car& setLicenseToNull(Boolean nullState=true)
      { theDataId.setLicenseToNull(nullState); return *this; }
  Car& setLicense(const IString& aString )
      { theDataId.setLicense(aString); return *this; }


  //***************************************************************************
  // Declaration of make 
  //***************************************************************************
private:
  IPOStringAttribute iMake;

  void getMakeFromBuffer( class IPOBufferBase* aBuffer );

public:
  static const INotificationId makeId;
  static const INotificationId makeNullId;
  const IString& make() const { return iMake.get(); }
  Boolean isMakeNull() const { return iMake.isNull(); }
  Boolean isMakeNullable() const { return true; }
  IString makeAsString() const { return iMake.asString(); }

public:
  Car& setMake(const IString& aMake);
  Car& setMakeToNull(Boolean nullState=true);


  //***************************************************************************
  // Declaration of model 
  //***************************************************************************
private:
  IPOStringAttribute iModel;

  void getModelFromBuffer( class IPOBufferBase* aBuffer );

public:
  static const INotificationId modelId;
  static const INotificationId modelNullId;
  const IString& model() const { return iModel.get(); }
  Boolean isModelNull() const { return iModel.isNull(); }
  Boolean isModelNullable() const { return true; }
  IString modelAsString() const { return iModel.asString(); }

public:
  Car& setModel(const IString& aModel);
  Car& setModelToNull(Boolean nullState=true);


  //***************************************************************************
  // Declaration of category 
  //***************************************************************************
private:
  IPOStringAttribute iCategory;

  void getCategoryFromBuffer( class IPOBufferBase* aBuffer );

public:
  static const INotificationId categoryId;
  static const INotificationId categoryNullId;
  const IString& category() const { return iCategory.get(); }
  Boolean isCategoryNull() const { return iCategory.isNull(); }
  Boolean isCategoryNullable() const { return true; }
  IString categoryAsString() const { return iCategory.asString(); }

public:
  Car& setCategory(const IString& aCategory);
  Car& setCategoryToNull(Boolean nullState=true);


  //***************************************************************************
  // Declaration of colour 
  //***************************************************************************
private:
  IPOStringAttribute iColour;

  void getColourFromBuffer( class IPOBufferBase* aBuffer );

public:
  static const INotificationId colourId;
  static const INotificationId colourNullId;
  const IString& colour() const { return iColour.get(); }
  Boolean isColourNull() const { return iColour.isNull(); }
  Boolean isColourNullable() const { return true; }
  IString colourAsString() const { return iColour.asString(); }

public:
  Car& setColour(const IString& aColour);
  Car& setColourToNull(Boolean nullState=true);


};

//***************************************************************************
//
//    CarManagerBase - persistent object list abstract base manager class
//
//***************************************************************************

class Car_IMPORTEXPORT CarManagerBase : public IPOManager
                                     , public IStandardNotifier
{
private:
  IDatastoreODBC* iObjectsDatastore;

public:
  virtual ~CarManagerBase();

  virtual CarManagerBase& refresh();
  virtual CarManagerBase& select( const char* clause );
  IDatastoreODBC* objectsDatastore() const;
  void setObjectsDatastore( IDatastoreODBC* aDatastore = 0 );
  IDatastoreODBC* currentDatastore() const;
  virtual CarManagerBase& initializePart();

  static const INotificationId readyId;
  static const INotificationId itemsId;
  static const INotificationId objectsDatastoreId;

protected:
  CarManagerBase();
  CarManagerBase( const CarManagerBase& aCarManager );
  Boolean makeConnections();
  virtual Car* newCar() = 0;
  virtual void addCar(Car*) = 0;
  CarManagerBase&
            operator= (const CarManagerBase& aCarManager);
  void fetchUsing( CarSelectStatement& aStatement );

};

//***************************************************************************
//
//  CarManagerTemplate - persistent object list manager class template
//     manager class support for classes derived from Car
//
//***************************************************************************

template < class CarType >
class CarManagerTemplate : public CarManagerBase
{
public:
  typedef CarType* elementType;
  typedef IVSequence <elementType> sequenceType;
  // use where string generator is required, via:
  //    CarManager::stringGenerator( "separator string" );
  class stringGenerator : public IStringGenerator<elementType>
  {
    private:
       class stringGeneratorFunction
               : public IStringGeneratorFn<elementType>
       {
          private:
            const char* iSeparator;
          public:
            stringGeneratorFunction(const char* separator)
                    : iSeparator(separator) {}
            IString stringFor(elementType const& aCar )
            {
              return aCar->forDisplay(iSeparator);
            }
       };
    public:
       stringGenerator( const char* separator = " " )
         : IStringGenerator<elementType>( IReference< IStringGeneratorFn<elementType> >
                  ( new stringGeneratorFunction(separator) ) )
       {}
  };


private:
  sequenceType theSequence;
  sequenceType proxySequence;
protected:
  void emptyTheSequence()
  {
    proxySequence = theSequence;
    theSequence.removeAll();
    while ( ! proxySequence.isEmpty() )
       {
          CarType* anElement = proxySequence.firstElement();
          proxySequence.removeFirst();
          delete anElement;
       }
  }
  void fillTheSequence()
  {
    theSequence = proxySequence;
    proxySequence.removeAll();
  }
private:
  void addCar( Car* aCar )
  {
     proxySequence.addAsLast((CarType*)aCar);
     postAddProcess((CarType*)aCar);
  }
  CarType* newCar()
  {
    CarType* aCar = new CarType;
    aCar->initializePart();
    return aCar;
  }

protected:
  // define pre-fetch behaviour on default constructor
  // override this method to add post-fetch behaviour
  virtual void postAddProcess( CarType* aCar ) {}

public:

  CarManagerTemplate(const INumber i=100)
        : CarManagerBase()
        , theSequence(i)
  {
    theSequence.enableNotification();
  }

  CarManagerTemplate(const CarManagerTemplate < CarType >& aCarManager
        , const INumber i=100 )
        : CarManagerBase(aCarManager)
        , theSequence(i)
  {
    sequenceType::Cursor cursor(aCarManager.theSequence);
    forCursor(cursor)
         theSequence.addAsLast(new CarType(*cursor.element()));
    theSequence.enableNotification();
  }

  virtual ~CarManagerTemplate()
  {
    emptyTheSequence();
  }

  sequenceType* items() { return &theSequence; }

  CarManagerTemplate< CarType >&
            operator= (const CarManagerTemplate< CarType >& aCarManager)
  {
    CarManagerBase::operator=(aCarManager);
    emptyTheSequence();
    sequenceType::Cursor cursor(aCarManager.theSequence);
    forCursor(cursor)
         proxySequence.addAsLast(new CarType(*cursor.element()));
    fillTheSequence();
    return *this;
  }

  virtual CarManagerTemplate < CarType >& refresh()
  {
    emptyTheSequence();
    try
       {
          CarManagerBase::refresh();
       }
    catch (...)
       {
          fillTheSequence();
          throw;
       }
    fillTheSequence();
    return *this;
  }

  virtual CarManagerTemplate < CarType >& select(const char* clause)
  {
    emptyTheSequence();
    try
       {
          CarManagerBase::select(clause);
       }
    catch (...)
       {
          fillTheSequence();
          throw;
       }
    fillTheSequence();
    return *this;
  }

};

//***************************************************************************
//
//    CarManager - persistent object list manager class
//
//***************************************************************************

class CarManager : public CarManagerTemplate< Car >
{
};

//***************************************************************************
//
//    CarDatastore - to access Car objects
//
//***************************************************************************

class CarDatastore: public IDatastoreODBC
{
public:
  CarDatastore() : IDatastoreODBC("daxsamp")
  {
    if ( Car::defaultDatastore() == 0 )
       Car::setDefaultDatastore(this);
  }
  ~CarDatastore()
  {
    if ( Car::defaultDatastore() == this )
       Car::setDefaultDatastore();
  }
  CarDatastore& setAsDefaultDatastore()
  {
    Car::setDefaultDatastore(this);
    return *this;
  }
};

#pragma pack()

#endif

