//******************************************************************************
//                                                                             *
//COPYRIGHT: Copyright (C) International Business Machines Corp., 1992,1994.   *
//                                                                             *
//DISCLAIMER OF WARRANTIES:                                                    *
//  The following [enclosed] code is sample code created by IBM                *
//  Corporation.  This sample code is not part of any standard IBM product     *
//  and is provided to you solely for the purpose of assisting you in the      *
//  development of your applications.  The code is provided "AS IS",           *
//  without warranty of any kind.  IBM shall not be liable for any damages     *
//  arising out of your use of the sample code, even if they have been         *
//  advised of the possibility of such damages.                                *
//                                                                             *
//******************************************************************************
//******************************************************************************
// File Name: client.cpp                                                       *
//                                                                             *
// Note: This file illustrates how a store class can be used.                  *
//                                                                             *
//******************************************************************************
#include "store.hpp"

void main(int argc, char * argv[]) {

  Store * ComputerShop;

  if (argc == 3)
    ComputerShop = new Store(argv[1], argv[2]);                    // send userid and password for connection
  else
    ComputerShop = new Store();                                    // send userid and password for connection

  // Generate a price list report of the current stock.
  cout << "The following is a price list before update:" << endl; endl;
  ComputerShop->generatePriceList();

  // Add a record if there is a new item.
  ComputerShop->addNewItem("HDR0025","Hard Drive 250MD IDE", 12, 200.00, 239.45);
  ComputerShop->addNewItem("HDR0034","Hard Drive 340MD IDE", 40, 220.00, 270.89);
  ComputerShop->addNewItem("CPU486a","486SLC-33 TI CPU,AMI", 12, 105.45, 139.99);
  ComputerShop->addNewItem("CPUPTMa","Pentium 60/66 PCI256", 23, 350.85, 459.50);

  // Commit the changes to the database
  ComputerShop->transaction(COMMIT);

  // Add a reocrd whenever an order has been received.
  ComputerShop->addReceivedOrder(123,"HDR0025", 10, 1800.00);
  ComputerShop->addReceivedOrder(124,"RAM4-72", 30, 6001.35);
  ComputerShop->addReceivedOrder(125,"CPUPTMa",  5, 1904.75);
  ComputerShop->addReceivedOrder(126,"MONAD14", 40, 1538.00);

  // Commit the changes to the database
  ComputerShop->transaction(COMMIT);

  // The inventory has to be posted.
  ComputerShop->postingInventory();

  // Commit the changes to the database
  ComputerShop->transaction(COMMIT);

  cout << endl << endl;
  cout << "The following is an updated price list:" << endl; endl;

  // Generate an updated report after posting.
  ComputerShop->generatePriceList();

}
