//******************************************************************************
//                                                                             *
//COPYRIGHT: Copyright (C) International Business Machines Corp., 1992,1994.   *
//                                                                             *
//DISCLAIMER OF WARRANTIES:                                                    *
//  The following [enclosed] code is sample code created by IBM                *
//  Corporation.  This sample code is not part of any standard IBM product     *
//  and is provided to you solely for the purpose of assisting you in the      *
//  development of your applications.  The code is provided "AS IS",           *
//  without warranty of any kind.  IBM shall not be liable for any damages     *
//  arising out of your use of the sample code, even if they have been         *
//  advised of the possibility of such damages.                                *
//                                                                             *
//******************************************************************************
//******************************************************************************
// File Name: store.hpp                                                        *
//                                                                             *
// Note: This file keeps the definiton of the store class.                     *
//                                                                             *
//******************************************************************************
#include <iostream.h>
#include <idsmcon.hpp>          // If using Embedded Datastore
#include <idsmcod.hpp>          // If using ODBC Datastore
#include <idsmcdb.hpp>          // If using CLI  Datastore
#include "invento.hpp"          // For the generated Inventory object classes
#include "receive.hpp"          // For the generated Receivedorder object classes
#include "prclist.hpp"          // For the generated PriceList object classes

enum postflag {NOT_POSTED, POSTED};    // enum flag for posted or not yet posted
enum commitflag {ROLLBACK, COMMIT};    // enum flag for commit or rollback

class Store {
public:
   Store(IString usrid, IString pwd);              // Constructor expects userid and password
   Store();                                        // Constructor expects no userid and no password
   ~Store();                                       // Destructor
   void generatePriceList();                       // Generate a price list
   void postingInventory();                        // update the inventory data with received order
   void displayItem();                             // display a price list item
   void transaction(commitflag commitflagArg);     // commit or rollback

   void addReceivedOrder(              // Add a received order to the database
          short  receivedNumberArg,    // received order number
          IString prodNumberArg,       // product number
          long    receivedQuantityArg, // recieved quantity
          double  totalCostArg);        // total cost of the order

   void addNewItem(                    // add a new item to the inventory table
          IString prodNumberArg,       // product number
          IString prodDescriptionArg,  // product description
          long    onHandQuantityArg,   // on hand quantity
          double  avarageCostArg,      // average cost per unit
          double  listingPriceArg);    // listing price per unit
private:
   ReceiveDatastore        dsm;                 // datastore manager
   InventoDatastore        dsm1;                // datastore manager
   PrclistDatastore        dsm2;                // datastore manager
   IDatastore              dsm3;                // IDatastore for Embedded SQL
   Invento                 inventoryObj;        // inventory class object
   Receive                 receivedOrderObj;    // received order class object
   ReceiveManager          receivedOrderMgr;    // received order manager
   Prclist                 priceList;
   PrclistManager          priceListMgr;        // price list object manager
   IString                 userid;              // userid used to logon to the database
   IString                 password;            // password used to logon to the database
   IString                 ISESQL;              // ISESQL environment variable for Embedded SQL
};

