/******************************************************************************
* .FILE:         2d-bmap.hpp                                                  *
*                                                                             *
* .DESCRIPTION:  2D Bitmap Graphic Sample Program:  Class Definitions         *
*                                                                             *
* .CLASSES:      DrawingAreaPaintHandler                                      *
*                MainCommandHandler                                           *
*                DrawingArea                                                  *
*                MainWindow                                                   *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1996 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/
#ifndef BITMAP_HPP
#define BITMAP_HPP

#include <iframe.hpp>
#include <icmdhdr.hpp>
#include <idrawcv.hpp>
#include <ivport.hpp>
#include <ipainhdr.hpp>
#include <igbitmap.hpp>
#include "2dbmap.h"

/***************************************************************************
* Class DrawingAreaPaintHandler - Handles repainting                       *
***************************************************************************/
class DrawingAreaPaintHandler : public IPaintHandler
{
typedef IPaintHandler
  Inherited;

protected:
/*------------------------------------------------------------------------|
| paintWindow is an overloaded function that repaints the window.         |
-------------------------------------------------------------------------*/
  virtual Boolean
    paintWindow( IPaintEvent& event );
};

/***************************************************************************
* Class MainCommandHandler - Handle command events for the main window.    *
***************************************************************************/
class MainCommandHandler : public ICommandHandler
{
typedef ICommandHandler
  Inherited;

protected:
/*------------------------------------------------------------------------|
| command is an overloaded function that handles command events.          |
-------------------------------------------------------------------------*/
virtual Boolean
  command( ICommandEvent& event );
};

/******************************************************************************
* Class DrawingArea - A drawing canvas to draw and modify bitmaps             *
******************************************************************************/
class DrawingArea : public IDrawingCanvas
{
typedef IDrawingCanvas
  Inherited;

public:
/*------------------------------- Constructor --------------------------------|
| Constructs the object with:                                                 |
| 1) the windowid and pointers to the parent window and owner window          |
-----------------------------------------------------------------------------*/
  DrawingArea( unsigned long id, IWindow* parent, IWindow* owner );

/*-------------------------------- Destructor --------------------------------|
| Destructs the object with:                                                  |
| 1) no parameters                                                            |
-----------------------------------------------------------------------------*/
  virtual
   ~DrawingArea();

/*----------------------------------------------------------------------------|
| loadBitmap   - loads a bitmap file form disk.                               |
| bitmap       - returns a pointer to its bitmap.                             |
| setClipStyle - set the clip style for the drawing area.                     |
-----------------------------------------------------------------------------*/
  DrawingArea
   &loadBitmap( const IString& imageFile );
  IGBitmap
   *bitmap() const;
  DrawingArea
   &setClipStyle ( unsigned long style ) { fStyle = style; return *this; }
  unsigned long
    clipStyle( ) const { return fStyle; }

protected:
  virtual ISize
    calcMinimumSize     ( ) const;

private:

  DrawingAreaPaintHandler
    drawingAreaPaintHandler;
  IGBitmap
   *fBitmap;
  unsigned long
    fStyle;
};

/******************************************************************************
* Class:   MainWindow - Main window for C++ 2D Bitmap sample application      *
******************************************************************************/
class MainWindow : public IFrameWindow
{
typedef IFrameWindow
  Inherited;

public:
/*------------------------------- Constructor --------------------------------|
| Constructs the object with:                                                 |
| 1)                                                                          |
-----------------------------------------------------------------------------*/
    MainWindow(unsigned long windowId);

/*-------------------------------- Destructor --------------------------------|
| Destructs the object with:                                                  |
| 1)                                                                          |
-----------------------------------------------------------------------------*/
virtual
  ~MainWindow();

/*----------------------------------------------------------------------------|
| loadImageFile - loads an image from a file.                                 |
| modifyBitmap  - Modifies the bitmap based upon the event id.                |
| draingArea    - Returns a reference to the drawing area.                    |
-----------------------------------------------------------------------------*/
  virtual MainWindow
   &loadImageFile( const IString& imageFile );
  virtual MainWindow
   &modifyBitmap( unsigned long eventId );
  DrawingArea
   &drawingArea( ) { return fDrawingArea; }

private:
  IViewPort
    fViewPort;
  DrawingArea
    fDrawingArea;
  MainCommandHandler
    fMainCommandHandler;
};

#endif
