/******************************************************************************
* .FILE:         2d-draw.h                                                    *
*                                                                             *
* .DESCRIPTION:  2D Graphics Drawing Program : Symbolic Definitions           *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1996 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/
#ifndef TWOD_H
#define TWOD_H
#define ID_NULL          -1
#define WND_MAIN            0x1000
#define WND_DRAW            0x1001
#define WND_TOOLBAR         0x1002
#define WND_TEXT            0x1003
#define STR_HELLO           0x1004
#define STR_INFO            0x1005

// Defines for graphic pushbuttons.  Do not move these out of order!
#define PALLET_NORM         0x3001
#define PALLET_LINE         0x3002
#define PALLET_DRAW         0x3003
#define PALLET_RECTANGLE    0x3004
#define PALLET_ELLIPSE      0x3005
#define PALLET_POLYLINE     0x3006
#define PALLET_POLYGON      0x3007
#define PALLET_ARC          0x3008
#define PALLET_PIE          0x3009
#define PALLET_CHORD        0x300A
#define PALLET_TEXT         0x300B
#define PALLET_BITMAP       0x300C
#define PALLET_DUMMY        0x300D

#define BMP_EAGLE           0x3200
#define TOOLBAR_SYSTEM      0x3201

#define LONG_OFFSET         100

#define STR_BMP_EXT         0x9000
#define STR_LOAD_IMG        0x9001
#define TITLE_DIALOG        0x9002
// Defines for menu items.

#define ID_FILEMENU                        2000
#define ID_VIEWMENU                        2001
#define ID_TOOLMENU                        2002
#define ID_FLCOLORS                        2003
#define ID_COLORS                          2004
#define ID_PATTERN                         2005
#define ID_LINETYPE                        2006
#define ID_LINEWIDTH                       2007
#define ID_STYLEMENU                       2008
#define ID_OPTIONSMENU                     2009
#define ID_SETFONT                         2010
#define ID_SETBITMAP                       2011
#define ID_BKCOL                           2012
#define ID_BKCOL_PIN                       2013
#define ID_BKCOL_DARKPIN                   2014
#define ID_BKCOL_BLU                       2015
#define ID_DRAWOPERATION                   2016
#define ID_FILL                            2017
#define ID_FRAME                           2018
#define ID_FILLANDFRAME                    2019
#define ID_BKCOL_DARKBLU                   2020
#define ID_BKCOL_CYA                       2021
#define ID_BKCOL_DARKCYA                   2022
#define ID_BKCOL_GRE                       2023
#define ID_BKCOL_DARKGRE                   2024
#define ID_BKCOL_YEL                       2025
#define ID_BKCOL_RED                       2026
#define ID_BKCOL_DARKRED                   2027
#define ID_BKCOL_BRO                       2028
#define ID_BKCOL_PALEGRA                   2029
#define ID_BKCOL_DARKGRA                   2030
#define ID_BKCOL_BLK                       2031
#define ID_BKCOL_WHT                       2032
#define ID_FLCOL_PIN                       2033
#define ID_FLCOL_DARKPIN                   2034
#define ID_FLCOL_BLU                       2035
#define ID_FLCOL_DARKBLU                   2036
#define ID_FLCOL_CYA                       2037
#define ID_FLCOL_DARKCYA                   2038
#define ID_FLCOL_GRE                       2039
#define ID_FLCOL_DARKGRE                   2040
#define ID_FLCOL_YEL                       2041
#define ID_FLCOL_RED                       2042
#define ID_FLCOL_DARKRED                   2043
#define ID_FLCOL_BRO                       2044
#define ID_FLCOL_PALEGRA                   2045
#define ID_FLCOL_DARKGRA                   2046
#define ID_FLCOL_BLK                       2047
#define ID_FLCOL_WHT                       2048
#define ID_COL_PIN                         2049
#define ID_COL_DARKPIN                     2050
#define ID_COL_BLU                         2051
#define ID_COL_DARKBLU                     2052
#define ID_COL_CYA                         2053
#define ID_COL_DARKCYA                     2054
#define ID_COL_GRE                         2055
#define ID_COL_DARKGRE                     2056
#define ID_COL_YEL                         2057
#define ID_COL_RED                         2058
#define ID_COL_DARKRED                     2059
#define ID_COL_BRO                         2060
#define ID_COL_PALEGRA                     2061
#define ID_COL_DARKGRA                     2062
#define ID_COL_BLK                         2063
#define ID_COL_WHT                         2064
#define ID_PENWIDTH_4                      2065
#define ID_PENWIDTH_3                      2066
#define ID_PENWIDTH_2                      2067
#define ID_PENWIDTH_1                      2068
#define ID_FILLPATTERN_SOLID               2069
#define ID_FILLPATTERN_DIAG4               2070
#define ID_FILLPATTERN_DIAG3               2071
#define ID_FILLPATTERN_DIAG2               2072
#define ID_FILLPATTERN_DIAG1               2073
#define ID_FILLPATTERN_VERT                2074
#define ID_FILLPATTERN_HORIZ               2075
#define ID_FILLPATTERN_DENSE8              2076
#define ID_FILLPATTERN_DENSE7              2077
#define ID_FILLPATTERN_DENSE6              2078
#define ID_FILLPATTERN_DENSE5              2079
#define ID_FILLPATTERN_DENSE4              2080
#define ID_FILLPATTERN_DENSE3              2081
#define ID_FILLPATTERN_DENSE2              2082
#define ID_FILLPATTERN_DENSE1              2083
#define ID_FILLPATTERN_NOSHADE             2084
#define ID_PENPATTERN_SOLID                2085
#define ID_PENPATTERN_DIAG4                2086
#define ID_PENPATTERN_DIAG3                2087
#define ID_PENPATTERN_DIAG2                2088
#define ID_PENPATTERN_DIAG1                2089
#define ID_PENPATTERN_VERT                 2090
#define ID_PENPATTERN_HORIZ                2091
#define ID_PENPATTERN_DENSE8               2092
#define ID_PENPATTERN_DENSE7               2093
#define ID_PENPATTERN_DENSE6               2094
#define ID_PENPATTERN_DENSE5               2095
#define ID_PENPATTERN_DENSE4               2096
#define ID_PENPATTERN_DENSE3               2097
#define ID_PENPATTERN_DENSE2               2098
#define ID_PENPATTERN_DENSE1               2099
#define ID_PENPATTERN_NOSHADE              2100
#define ID_PENTYPE_ALTERNATE               2101
#define ID_PENTYPE_SOLID                   2102
#define ID_PENTYPE_DASHDOUBLEDOT           2103
#define ID_PENTYPE_LONGDASH                2104
#define ID_PENTYPE_DOUBLEDOT               2105
#define ID_PENTYPE_DASHDOT                 2106
#define ID_PENTYPE_SHORTDASH               2107
#define ID_PENTYPE_DOT                     2108

#endif
