/******************************************************************************
* .FILE:         2d-draw.hpp                                                  *
*                                                                             *
* .DESCRIPTION:  2D Graphics Drawing Program : Class Definitions              *
*                                                                             *
* .CLASSES:      MainWindow                                                   *
*                DrawingArea                                                  *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1996 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/
#ifndef TWOD_HPP
#define TWOD_HPP
#include <iframe.hpp>
#include <isizehdr.hpp>
#include <icmdhdr.hpp>
#include <igrafctx.hpp>
#include <igbundle.hpp>
#include <idrawcv.hpp>
#include <imenubar.hpp>
#include <imndihdr.hpp>
#include <imndievt.hpp>
#include <ireslib.hpp>
#include <imoushdr.hpp>
#include <imousevt.hpp>
#include <iflyhhdr.hpp>
#include <iflytext.hpp>
#include <ifont.hpp>
#include <iinfoa.hpp>
#include <itbar.hpp>
#include <itbarbut.hpp>
#include <igrect.hpp>
#include "2ddraw.h"

//**************************************************************************
// Class:   DrawingArea                                                    *
//                                                                         *
// Purpose: Subclass of IDrawingCanvas.  Class contains the handlers       *
//          necessary for interactive drawing of the graphic objects.      *
//                                                                         *
//**************************************************************************
class DrawingArea : public IDrawingCanvas,
                    public IMouseHandler
{
public:
  DrawingArea  ( unsigned long windowId,
                 IWindow* parent,
                 IWindow* owner,
                 const IRectangle& intial = IRectangle() );
virtual
  ~DrawingArea ( );

enum DrawState {
  drawing,
  waitingForInput,
  notDrawing
  };

DrawingArea
  &setDrawState        ( const DrawState newState = drawing );
DrawState
  drawState            ( ) const { return dState; }

DrawingArea
  &setBitmapFileName   ( const IString& bitmapFile )
                         { currentBitmap = bitmapFile;
                           return *this; }
IString
  bitmapFileName       ( ) const
                         { return currentBitmap; }

enum DrawObject {
  pointer = PALLET_NORM,
  line,
  freeHand,
  rectangle,
  ellipse,
  polyline,
  polygon,
  arc,
  pie,
  chord,
  text,
  bitmap
  };

virtual DrawingArea
  &setDrawObject       ( const DrawObject drawObject )
                         { currentObj = drawObject;
                           return *this; }
virtual DrawObject
  drawObject           ( ) const {return currentObj;}

virtual IGraphicBundle
  &graphicBundle       ( ) { return currentBundle; }

virtual DrawingArea
  &setCurrentFont      ( const IFont& font );
virtual IFont
  currentFont          ( ) const;

protected:

virtual Boolean
  mouseMoved           ( IMouseEvent&        event ),
  mouseClicked         ( IMouseClickEvent&   event ),
  mousePointerChange   ( IMousePointerEvent& event );

virtual DrawingArea
  &button1Down         ( const IPoint&       point ),
  &button1Up           ( const IPoint&       point ),
  &button1DoubleClick  ( const IPoint&       point ),
  &button2Down         ( const IPoint&       point ),
  &button2Up           ( const IPoint&       point );

private:
  IFont              currentfont;
  IGraphicBundle     currentBundle;
  IGraphicBundle     animateBundle;
  IString            currentBitmap;
  DrawState          dState;
  DrawObject         currentObj;
  IGraphic*          iGraphic;
  IGraphic*          moveGraphic;
  IGRectangle        moveRect;
  IPoint             startingPt;
  IPoint             previousPt;
  IPoint             tempPt;
  unsigned long      pointCount;
  IPointerHandle     ptrLine;
  IPointerHandle     ptrDraw;
  IPointerHandle     ptrRectangle;
  IPointerHandle     ptrEllipse;
  IPointerHandle     ptrPolyline;
  IPointerHandle     ptrPolygon;
  IPointerHandle     ptrArc;
  IPointerHandle     ptrPie;
  IPointerHandle     ptrChord;
  IPointerHandle     ptrText;
  IPointerHandle     ptrBitmap;
  IPointerHandle     ptrCurrent;
};

//**************************************************************************
// Class:   MainWindow                                                     *
//                                                                         *
// Purpose: Main Window for C++ Hello World sample application             *
//          It is a subclass of IFrameWindow                               *
//                                                                         *
//**************************************************************************
class MainWindow : public IFrameWindow,
                   public ICommandHandler,
                   public IMenuDrawItemHandler
{
public:                               //Define the Public Information

  MainWindow(unsigned long windowId); //Constructor for this class

virtual
  ~MainWindow();

static IColor
  penColorFromId                ( unsigned long Identifier ),
  fillColorFromId               ( unsigned long Identifier ),
  backColorFromId               ( unsigned long Identifier );

static unsigned long
  patternFromId                 ( unsigned long Identifier ),
  penWidthFromId                ( unsigned long Identifier );

static IGraphicBundle::PenType
  penTypeFromId                 ( unsigned long Identifier );

protected:

virtual Boolean
  setSize                       ( IMenuDrawItemEvent& evt,
                                  ISize&              newSize ),
  draw                          ( IMenuDrawItemEvent& evt,
                                  DrawFlag&           flag    ),

  command                       ( ICommandEvent&      event   );

private:                              //Define Private Information
  DrawingArea         drawingArea;    // move back to top of list.
  IToolBar            toolBar;
  IMenuBar            menuBar;
  IInfoArea           infoArea;
  IFlyText            flyText;
  IFlyOverHelpHandler flyOver;
  unsigned long       lastPenColorId;
  unsigned long       lastFillColorId;
  unsigned long       lastPenPatternId;
  unsigned long       lastFillPatternId;
  unsigned long       lastPenTypeId;
  unsigned long       lastPenWidthId;
  unsigned long       lastBackId;
  unsigned long       lastDrawOperationId;
  IToolBarButton      normalButton,
                      lineButton,
                      drawButton,
                      rectangleButton,
                      ellipseButton,
                      polylineButton,
                      polygonButton,
                      arcButton,
                      pieButton,
                      chordButton,
                      textButton,
                      bitmapButton;
};
#endif
